/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils;

import java.util.HashMap;
import java.util.Map;

public class HtmlUtils {
    private static final Map<String, String> htmlEscapeMap = new HashMap<String, String>();

    public static String unescapeHtml(String html) {
        for (Map.Entry<String, String> entry : htmlEscapeMap.entrySet()) {
            html = html.replaceAll(entry.getKey(), entry.getValue());
        }
        return html.trim();
    }

    static {
        htmlEscapeMap.put("&#38;nbsp;", " ");
        htmlEscapeMap.put("&nbsp;", " ");
        htmlEscapeMap.put("&#10;", "");
        htmlEscapeMap.put("&quot;", "\"");
        htmlEscapeMap.put("&apos;", "'");
        htmlEscapeMap.put("&", "&");
        htmlEscapeMap.put("<", "<");
        htmlEscapeMap.put(">", ">");
        htmlEscapeMap.put("&copy;", "\u00a9");
        htmlEscapeMap.put("&reg;", "\u00ae");
        htmlEscapeMap.put("&trade;", "TM");
        htmlEscapeMap.put("&sect;", "\u00a7");
        htmlEscapeMap.put("&ldquo;", "\"");
        htmlEscapeMap.put("&rdquo;", "\"");
        htmlEscapeMap.put("&lsquo;", "'");
        htmlEscapeMap.put("&rsquo;", "'");
        htmlEscapeMap.put("&ensp;", " ");
        htmlEscapeMap.put("&emsp;", " ");
        htmlEscapeMap.put("&#x;", "");
    }
}

