/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.interceptor;

import com.pangubpm.common.interceptor.Dialect;
import com.pangubpm.common.interceptor.DialectType;
import com.pangubpm.common.page.PageList;
import com.pangubpm.common.page.Pageable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PageInterceptor
implements Interceptor {
    private static final Log logger = LogFactory.getLog(PageInterceptor.class);
    private static Dialect DIALECT_CLASS = null;
    private static int MAPPED_STATEMENT_INDEX = 0;
    private static int PARAMETER_INDEX = 1;
    private static int ROWBOUNDS_INDEX = 2;

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] queryArgs = invocation.getArgs();
        RowBounds rowBounds = (RowBounds)queryArgs[ROWBOUNDS_INDEX];
        String dataType = DialectType.getDataType();
        if (!(rowBounds instanceof Pageable)) {
            return invocation.proceed();
        }
        MappedStatement mappedStatement = (MappedStatement)queryArgs[MAPPED_STATEMENT_INDEX];
        Object parameterObject = queryArgs[PARAMETER_INDEX];
        BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
        HashMap<String, Object> pageParameters = new HashMap<String, Object>();
        if (parameterObject instanceof Map) {
            pageParameters.putAll((Map)parameterObject);
        } else {
            for (ParameterMapping parameterMappings : boundSql.getParameterMappings()) {
                pageParameters.put(parameterMappings.getProperty(), parameterObject);
            }
        }
        ArrayList<ParameterMapping> parameterMappings1 = new ArrayList<ParameterMapping>(boundSql.getParameterMappings());
        Pageable page1 = (Pageable)rowBounds;
        if (page1.isOnlySort()) {
            StringBuilder sql1 = new StringBuilder(boundSql.getSql());
            sql1.append(" order by ").append(page1.getSort());
            queryArgs[PageInterceptor.MAPPED_STATEMENT_INDEX] = this.copyFromNewSql(mappedStatement, boundSql, sql1.toString(), parameterMappings1, pageParameters);
            return invocation.proceed();
        }
        String sql = boundSql.getSql();
        if (StringUtils.isNotBlank((CharSequence)page1.getSort())) {
            StringBuilder pageSql = new StringBuilder(sql);
            pageSql.append(" order by ").append(page1.getSort());
            sql = pageSql.toString();
        }
        String pageSql1 = DIALECT_CLASS.buildPageSqlAndSetParameters(mappedStatement, sql, page1, pageParameters, parameterMappings1);
        queryArgs[PageInterceptor.MAPPED_STATEMENT_INDEX] = this.copyFromNewSql(mappedStatement, boundSql, pageSql1, parameterMappings1, pageParameters);
        queryArgs[PageInterceptor.PARAMETER_INDEX] = pageParameters;
        queryArgs[PageInterceptor.ROWBOUNDS_INDEX] = new RowBounds(0, Integer.MAX_VALUE);
        int totalCount = PageInterceptor.getCount(mappedStatement, parameterObject, boundSql);
        PageList pageList = new PageList(page1.getCurrentPage(), page1.getPageSize());
        pageList.setTotalCount(totalCount);
        long totalPage = (long)totalCount / pageList.getPageSize() + (long)((long)totalCount % pageList.getPageSize() == 0L ? 0 : 1);
        pageList.setTotalPage(totalPage);
        Object result = invocation.proceed();
        pageList.addAll((List)result);
        return pageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) throws SQLException {
        int var10;
        String countSql = "select count(0) from (" + boundSql.getSql() + ") as total";
        String dataType = DialectType.getDataType();
        if (StringUtils.isNotEmpty((CharSequence)dataType) && "oracle".equals(dataType)) {
            countSql = "select count(0) from (" + boundSql.getSql() + ") ";
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Total count SQL [{}] " + countSql);
            logger.debug("Total count Parameters: {} " + parameterObject);
        }
        Connection connection = null;
        PreparedStatement countStmt = null;
        ResultSet rs = null;
        try {
            connection = mappedStatement.getConfiguration().getEnvironment().getDataSource().getConnection();
            countStmt = connection.prepareStatement(countSql);
            DefaultParameterHandler handler = new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
            handler.setParameters(countStmt);
            rs = countStmt.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Total count: {}" + count);
            }
            var10 = count;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (countStmt != null) {
                        countStmt.close();
                    }
                }
                finally {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
            }
        }
        return var10;
    }

    private MappedStatement copyFromNewSql(MappedStatement ms, BoundSql boundSql, String sql, List<ParameterMapping> parameterMappings, Object parameter) {
        BoundSql newBoundSql = this.copyFromBoundSql(ms, boundSql, sql, parameterMappings, parameter);
        return this.copyFromMappedStatement(ms, new BoundSqlSqlSource(newBoundSql));
    }

    private BoundSql copyFromBoundSql(MappedStatement ms, BoundSql boundSql, String sql, List<ParameterMapping> parameterMappings, Object parameter) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, parameterMappings, parameter);
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return newBoundSql;
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuffer keyProperties = new StringBuffer();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Properties properties) {
        logger.debug("mybatis setProperties");
        if (DIALECT_CLASS == null) {
            Properties properties2 = properties;
            synchronized (properties2) {
                if (DIALECT_CLASS == null) {
                    String dialectClassStr = properties.getProperty("dialectClass");
                    Class<?> dialectClass = null;
                    try {
                        dialectClass = Class.forName(dialectClassStr);
                        Constructor<?> e = dialectClass.getConstructor(new Class[0]);
                        DIALECT_CLASS = (Dialect)e.newInstance(new Object[0]);
                    }
                    catch (Exception var6) {
                        throw new RuntimeException(new ClassNotFoundException("Cannot create dialect instance: " + dialectClass, var6));
                    }
                    logger.debug("mybatis load dialectClass");
                }
            }
        }
    }

    public static class BoundSqlSqlSource
    implements SqlSource {
        BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

