/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.core.controller;

import com.pangubpm.common.core.domain.AjaxResult;
import com.pangubpm.common.core.page.PageDomain;
import com.pangubpm.common.core.page.TableDataInfo;
import com.pangubpm.common.core.page.TableSupport;
import com.pangubpm.common.utils.DateLocalUtils;
import com.pangubpm.common.utils.StringUtils;
import com.pangubpm.common.web.AbstractController;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

public class BaseController
extends AbstractController {
    protected final Logger logger = LoggerFactory.getLogger(BaseController.class);

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(DateLocalUtils.parseDate(text));
            }
        });
    }

    @Override
    public Map<String, Object> getPageInfo(HttpServletRequest request) {
        PageDomain pageDomain = TableSupport.buildPageRequest(request);
        String pageNum = pageDomain.getPageNum();
        String pageSize = pageDomain.getPageSize();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", pageSize);
        params.put("page", pageNum);
        return params;
    }

    @Override
    protected TableDataInfo getDataTable(List<?> list, long total) {
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setMsg("\u67e5\u8be2\u6210\u529f");
        rspData.setData(list);
        rspData.setCount(total);
        return rspData;
    }

    @Override
    protected AjaxResult toAjax(int rows) {
        return rows > 0 ? AjaxResult.success() : AjaxResult.error();
    }

    public String redirect(String url) {
        return StringUtils.format("redirect:{}", url);
    }
}

