/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils.tree;

import cn.hutool.core.util.ReflectUtil;
import com.pangubpm.common.utils.tree.ListUtil;
import com.pangubpm.common.utils.tree.TreeChild;
import com.pangubpm.common.utils.tree.TreeId;
import com.pangubpm.common.utils.tree.TreeParentId;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bean2TreeUtil<T> {
    protected final Log log = LogFactory.getLog(this.getClass());
    private List<T> returnList = new ArrayList<T>();
    private boolean order;
    private LinkedHashMap<String, Integer> orderMap;

    public Bean2TreeUtil() {
    }

    public Bean2TreeUtil(LinkedHashMap<String, Integer> orderMap) {
        this.order = true;
        this.orderMap = orderMap;
    }

    public List<T> getChildNodesByParentId(List<T> sourceList, Object parentId) {
        if (sourceList == null || sourceList.isEmpty() || parentId == null) {
            this.log.error((Object)"\u6570\u636e\u6e90\u4e3a Null \u6216 \u4e3a\u7a7a \u6216 id \u4e3a Null");
            return this.returnList;
        }
        if (this.order) {
            ListUtil.ListSort.sortMap(sourceList, this.orderMap);
        }
        for (T node : sourceList) {
            Object parentId1 = this.getParentId(node);
            if (!StringUtils.isNotEmpty((CharSequence)parentId1.toString()) || !StringUtils.isNotEmpty((CharSequence)parentId.toString()) || !parentId1.toString().equals(parentId.toString())) continue;
            this.recursion(sourceList, node);
            this.returnList.add(node);
        }
        return this.returnList;
    }

    public List<T> getChildNodesById(List<T> sourceList, Object id) {
        if (sourceList == null || sourceList.isEmpty() || id == null) {
            this.log.error((Object)"\u6570\u636e\u6e90\u4e3a Null \u6216 \u4e3a\u7a7a \u6216 id \u4e3a Null");
            return this.returnList;
        }
        if (this.order) {
            ListUtil.ListSort.sortMap(sourceList, this.orderMap);
        }
        for (T node : sourceList) {
            if (!this.getId(node).equals(id.toString())) continue;
            this.recursion(sourceList, node);
            this.returnList.add(node);
        }
        return this.returnList;
    }

    public List<T> flatTree(List<? extends T> sourceList) {
        ArrayList out = new ArrayList();
        sourceList.forEach(s -> this.flatRecursion(s, out));
        return out;
    }

    private void flatRecursion(T source, List<T> out) {
        out.add(source);
        List<T> children = this.getChild(source);
        if (children == null || children.isEmpty()) {
            return;
        }
        for (T child : children) {
            this.flatRecursion(child, out);
        }
    }

    private void recursion(List<T> sourceList, T node) {
        List<T> childList = this.getChildList(sourceList, node);
        if (this.order && childList != null && !childList.isEmpty()) {
            ListUtil.ListSort.sortMap(childList, this.orderMap);
        }
        if (this.hasChild(sourceList, node)) {
            this.setChild(node, childList);
            if (childList != null) {
                for (T childNode : childList) {
                    this.recursion(sourceList, childNode);
                }
            }
        } else {
            this.setChild(node, childList);
        }
    }

    private List<T> getChildList(List<T> list, T node) {
        ArrayList<T> nodeList = new ArrayList<T>();
        for (T childNode : list) {
            String patentId = this.getParentId(childNode).toString();
            String id = this.getId(node).toString();
            if (!StringUtils.isNotEmpty((CharSequence)patentId) || !StringUtils.isNotEmpty((CharSequence)id) || !patentId.equals(id)) continue;
            nodeList.add(childNode);
        }
        return nodeList;
    }

    private boolean hasChild(List<T> list, T node) {
        return this.getChildList(list, node).size() > 0;
    }

    private Object getParentId(T node) {
        return BeanUtil.getFiledValueByAnnotation(node, TreeParentId.class);
    }

    private Object getId(T node) {
        return BeanUtil.getFiledValueByAnnotation(node, TreeId.class);
    }

    private void setChild(T node, List<T> nodeList) {
        BeanUtil.setFiledValueByAnnotation(node, TreeChild.class, nodeList);
    }

    private List<T> getChild(T node) {
        return (List)BeanUtil.getFiledValueByAnnotation(node, TreeChild.class);
    }

    static class BeanUtil {
        BeanUtil() {
        }

        public static Object getFiledValueByAnnotation(Object bean, Class<? extends Annotation> annotationClass) {
            Field[] fields;
            Class<?> beanClass = bean.getClass();
            for (Field field : fields = ReflectUtil.getFields(beanClass)) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                field.setAccessible(true);
                return ReflectUtil.getFieldValue((Object)bean, (Field)field);
            }
            return null;
        }

        public static void setFiledValueByAnnotation(Object bean, Class<? extends Annotation> annotationClass, Object value) {
            Field[] fields;
            Class<?> beanClass = bean.getClass();
            for (Field field : fields = ReflectUtil.getFields(beanClass)) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                ReflectUtil.setFieldValue((Object)bean, (Field)field, (Object)value);
            }
        }
    }
}

