/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils.tree;

import cn.hutool.core.bean.BeanUtil;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.comparators.ComparableComparator;

public class ListUtil {
    public static <T> Set<Object> listField2Set(String field, List<T> targetList) {
        HashSet<Object> set = new HashSet<Object>(0);
        for (T t : targetList) {
            Object fieldValue = BeanUtil.getFieldValue(t, (String)field);
            if (fieldValue == null) continue;
            set.add(fieldValue.toString());
        }
        return set;
    }

    public static class ListSort {
        public static final int ASC = 0;
        public static final int DESC = 1;

        public static <T> void sortMap(List<T> targetList, String key, Integer sortMode) {
            Object comparator = ComparableComparator.getInstance();
            comparator = ComparatorUtils.nullLowComparator((Comparator)comparator);
            if (sortMode.equals(1)) {
                comparator = ComparatorUtils.reversedComparator((Comparator)comparator);
            }
            targetList.sort((Comparator<T>)new BeanComparator(key, (Comparator)comparator));
        }

        public static <T> void sortMap(List<T> targetList, LinkedHashMap<String, Integer> orderMap) {
            orderMap.forEach((k, v) -> ListSort.sortMap(targetList, k, v));
            targetList.sort((a, b) -> {
                Map.Entry entry;
                int ret = 0;
                Iterator iterator = orderMap.entrySet().iterator();
                while (iterator.hasNext() && (ret = ListSort.compareObject((String)(entry = iterator.next()).getKey(), ((Integer)entry.getValue()).equals(0), a, b)) == 0) {
                }
                return ret;
            });
        }

        private static <E> int compareObject(String sortName, boolean isAsc, E fieldOne, E fieldTwo) {
            Object value1 = BeanUtil.getFieldValue(fieldOne, (String)sortName);
            Object value2 = BeanUtil.getFieldValue(fieldTwo, (String)sortName);
            if (value1 == null && value2 != null) {
                return isAsc ? -1 : 1;
            }
            if (value1 != null && value2 == null) {
                return isAsc ? 1 : -1;
            }
            if (value1 == null) {
                return 0;
            }
            String str1 = value1.toString();
            String str2 = value2.toString();
            if (value1 instanceof Number && value2 instanceof Number) {
                int maxLen = Math.max(str1.length(), str2.length());
                str1 = ListSort.addZero2Str((Number)value1, maxLen);
                str2 = ListSort.addZero2Str((Number)value2, maxLen);
            } else if (value1 instanceof Date && value2 instanceof Date) {
                long time1 = ((Date)value1).getTime();
                long time2 = ((Date)value2).getTime();
                int maxLen = Long.toString(Math.max(time1, time2)).length();
                str1 = ListSort.addZero2Str(time1, maxLen);
                str2 = ListSort.addZero2Str(time2, maxLen);
            }
            int ret = isAsc ? str1.compareTo(str2) : str2.compareTo(str1);
            return ret;
        }

        private static String addZero2Str(Number numObj, int length) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setGroupingUsed(false);
            nf.setMaximumIntegerDigits(length);
            nf.setMinimumIntegerDigits(length);
            return nf.format(numObj);
        }
    }

    public static class LinkedHashSet<T>
    extends java.util.LinkedHashSet<T> {
        public static <T> LinkedHashSet build() {
            return new LinkedHashSet<T>();
        }

        public LinkedHashSet<T> adds(T value) {
            super.add(value);
            return this;
        }
    }

    public static class LinkedList<T>
    extends java.util.LinkedList<T> {
        public static <T> LinkedList build() {
            return new LinkedList<T>();
        }

        public LinkedList<T> adds(T value) {
            super.add(value);
            return this;
        }
    }

    public static class ArrayList<T>
    extends java.util.ArrayList<T> {
        public static <T> ArrayList build() {
            return new ArrayList<T>();
        }

        public ArrayList<T> adds(T value) {
            super.add(value);
            return this;
        }
    }
}

