/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateUtils {
    private static Pattern PATTERN = Pattern.compile("^\\d+(,\\d+)*(\\.\\d+)*$");
    private static String defaultCharacter = "UTF-8";
    private static Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);

    private TemplateUtils() {
    }

    public static String processTemplate(String myTemplate, Map<String, Object> map) {
        String result = null;
        String name = "template";
        try {
            StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
            stringTemplateLoader.putTemplate(name, myTemplate);
            cfg.setTemplateLoader((TemplateLoader)stringTemplateLoader);
            Template template = cfg.getTemplate(name, defaultCharacter);
            StringWriter out = new StringWriter();
            template.process(map, (Writer)out);
            out.flush();
            result = out.toString();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Matcher matcher = PATTERN.matcher(result);
        if (matcher.find()) {
            return result.replaceAll(",", "");
        }
        return result;
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("number", "3333,123,123,342.000");
        String template = "${number}";
        String result = TemplateUtils.processTemplate(template, map);
        System.out.println(result);
    }

    static {
        cfg.setDefaultEncoding(defaultCharacter);
        cfg.setTagSyntax(0);
    }
}

