/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateUtils {
    private static Pattern PATTERN = Pattern.compile("^\\d+(,\\d+)*(\\.\\d+)*$");
    private static Pattern EXPRESS = Pattern.compile("\\$\\{([^}]+)}");
    private static String defaultCharacter = "UTF-8";
    private static Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);

    private TemplateUtils() {
    }

    public static String processTemplate(String myTemplate, Map<String, Object> map) {
        String result = null;
        String name = "template";
        Matcher matcher = EXPRESS.matcher(myTemplate);
        while (matcher.find()) {
            Matcher rowMatcher;
            String fieldName = matcher.group(1);
            Object o = map.get(fieldName);
            if (o == null || !(rowMatcher = PATTERN.matcher(o.toString())).find()) continue;
            map.put(fieldName, o.toString().replaceAll(",", ""));
        }
        try {
            StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
            stringTemplateLoader.putTemplate(name, myTemplate);
            cfg.setTemplateLoader((TemplateLoader)stringTemplateLoader);
            Template template = cfg.getTemplate(name, defaultCharacter);
            StringWriter out = new StringWriter();
            template.process(map, (Writer)out);
            out.flush();
            result = out.toString();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("purchaseType", "01");
        map.put("totalAmount", "3333,123,123,342.000");
        map.put("applicant", "1001_\u6768\u5a01");
        String template = "\"${purchaseType}\" == \"01\" && ${totalAmount} >= 200000 && \"${applicant}\" != \"1001_\u6768\u5a01\" && \"${applicant}\" != \"xuhao_\u5f90\u660a\"";
        String result = TemplateUtils.processTemplate(template, map);
        System.out.println(result);
    }

    static {
        cfg.setDefaultEncoding(defaultCharacter);
        cfg.setTagSyntax(0);
    }
}

