/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.web;

import com.pangubpm.common.core.domain.AjaxResult;
import com.pangubpm.common.core.page.PageDomain;
import com.pangubpm.common.core.page.TableDataInfo;
import com.pangubpm.common.core.page.TableSupport;
import com.pangubpm.common.page.PageData;
import com.pangubpm.common.page.PageList;
import com.pangubpm.common.page.PageVo;
import com.pangubpm.common.page.Pageable;
import com.pangubpm.common.utils.Result;
import com.pangubpm.common.web.LoginUserInfoAdapter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private LoginUserInfoAdapter loginUserInfoAdapter;

    protected String getTenantId() {
        return this.loginUserInfoAdapter.getTenantId();
    }

    protected String getUserId(HttpServletRequest request) {
        return this.loginUserInfoAdapter.getUserId(request);
    }

    protected String getUserNameFetchJwt() {
        return this.loginUserInfoAdapter.getUserName();
    }

    protected String getUserNo(HttpServletRequest request) {
        return this.getUserId(request);
    }

    protected String getUserName() {
        return this.getUserNameFetchJwt();
    }

    protected String getDeptId() {
        return this.loginUserInfoAdapter.getDeptId();
    }

    protected Result verification(Map<String, Object> params) {
        if (params.get("page") == null || params.get("limit") == null) {
            return Result.error("\u5fc5\u8981\u53c2\u6570\u7f3a\u5931");
        }
        return null;
    }

    public static Map<String, Object> getAllParameters(HttpServletRequest request) {
        Enumeration enums = request.getParameterNames();
        HashMap<String, Object> parameters = new HashMap<String, Object>(10);
        while (enums.hasMoreElements()) {
            String filedName = (String)enums.nextElement();
            String searchParameter = request.getParameter(filedName);
            if (StringUtils.isEmpty((CharSequence)searchParameter)) continue;
            parameters.put(filedName, searchParameter);
        }
        return parameters;
    }

    public static PageVo parametToPageVo(HttpServletRequest request) {
        PageVo vo = new PageVo();
        Enumeration enums = request.getParameterNames();
        HashMap<String, Object> parameters = new HashMap<String, Object>(10);
        while (enums.hasMoreElements()) {
            String filedName = (String)enums.nextElement();
            String searchParameter = request.getParameter(filedName);
            if (StringUtils.isEmpty((CharSequence)searchParameter)) continue;
            parameters.put(filedName, searchParameter);
        }
        vo.setParameters(parameters);
        Pageable pageable = new Pageable();
        String page = request.getParameter("page");
        String length = request.getParameter("length");
        if (StringUtils.isEmpty((CharSequence)length)) {
            length = "100";
        }
        if (StringUtils.isEmpty((CharSequence)page)) {
            page = "1";
        }
        String order = request.getParameter("order[0][column]");
        String orderDir = request.getParameter("order[0][dir]");
        String orderColumn = request.getParameter("columns[" + order + "][data]");
        HashMap<String, Object> sortParameters = new HashMap<String, Object>();
        sortParameters.put("orderColumn", orderColumn);
        sortParameters.put("orderDir", orderDir);
        vo.setSort(sortParameters);
        pageable.setPageSize(Integer.valueOf(length));
        pageable.setCurrentPage(Integer.valueOf(page));
        vo.setPageable(pageable);
        return vo;
    }

    public static PageData resultToDataTable(PageList list) {
        PageData dt = new PageData();
        if (list != null) {
            long displayCount = list.size();
            long totalCount = list.getTotalCount();
            dt.setAaData(list);
            dt.setTotalDisplayRecords(displayCount);
            dt.setTotal(totalCount);
        }
        return dt;
    }

    public Map<String, Object> getPageInfo(HttpServletRequest request) {
        PageDomain pageDomain = TableSupport.buildPageRequest(request);
        String pageNum = pageDomain.getPageNum();
        String pageSize = pageDomain.getPageSize();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", pageSize);
        params.put("page", pageNum);
        return params;
    }

    protected TableDataInfo getDataTable(List<?> list, long total) {
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setMsg("\u67e5\u8be2\u6210\u529f");
        rspData.setData(list);
        rspData.setCount(total);
        return rspData;
    }

    protected AjaxResult toAjax(int rows) {
        return rows > 0 ? AjaxResult.success() : AjaxResult.error();
    }
}

