/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils.spring;

import com.pangubpm.common.utils.StringUtils;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public final class SpringUtils
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static ConfigurableListableBeanFactory beanFactory;
    private static ApplicationContext applicationContext;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        SpringUtils.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringUtils.applicationContext = applicationContext;
    }

    public static <T> T getBean(String name) {
        return (T)beanFactory.getBean(name);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)applicationContext.getBean(name, clazz);
    }

    public static <T> T getBean(Class<T> clz) {
        return (T)beanFactory.getBean(clz);
    }

    public static boolean containsBean(String name) {
        return beanFactory.containsBean(name);
    }

    public static boolean isSingleton(String name) {
        return beanFactory.isSingleton(name);
    }

    public static Class<?> getType(String name) {
        return beanFactory.getType(name);
    }

    public static String[] getAliases(String name) {
        return beanFactory.getAliases(name);
    }

    public static String[] getActiveProfiles() {
        return applicationContext.getEnvironment().getActiveProfiles();
    }

    public static String getActiveProfile() {
        Object[] activeProfiles = SpringUtils.getActiveProfiles();
        return StringUtils.isNotEmpty(activeProfiles) ? activeProfiles[0] : null;
    }
}

