/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.config;

import com.pangu.form.api.FormRepositoryService;
import com.pangu.form.api.FormService;
import com.pangu.form.engine.FormEngine;
import com.pangu.form.engine.FormEngineConfiguration;
import com.pangu.form.spring.FormEngineFactoryBean;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class BpmFormConfig {
    @Autowired
    protected DataSource dataSource;
    @Autowired
    protected PlatformTransactionManager transactionManager;

    @Bean(name={"formEngineConfiguration"})
    @Primary
    public FormEngineConfiguration formEngineConfiguration() {
        FormEngineConfiguration standaloneFormEngineConfiguration = new FormEngineConfiguration();
        standaloneFormEngineConfiguration.setDataSource(this.dataSource);
        standaloneFormEngineConfiguration.setDatabaseSchemaUpdate("false");
        return standaloneFormEngineConfiguration;
    }

    @Bean(name={"formEngine"})
    public FormEngineFactoryBean formEngineFactoryBean() {
        FormEngineFactoryBean factoryBean = new FormEngineFactoryBean();
        factoryBean.setFormEngineConfiguration(this.formEngineConfiguration());
        return factoryBean;
    }

    @Bean
    @Primary
    public FormRepositoryService formRepositoryService(FormEngine formEngine) {
        return formEngine.getFormRepositoryService();
    }

    @Bean
    public FormService formService() {
        FormService formService = this.formEngineConfiguration().getFormService();
        return formService;
    }
}

