/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.pangubpm.common.utils.DateUtils;
import com.pangubpm.common.utils.StringUtil;
import com.pangubpm.modules.form.entity.FormBusinessModelColumnEntity;
import java.math.BigDecimal;
import java.util.Map;
import java.util.regex.Pattern;

public class DbHandler {
    public static final String NUM_TYPE_INT = "int";
    public static final String NUM_TYPE_INTEGER = "Integer";
    public static final String NUM_TYPE_DOUBLE = "double";
    public static final String NUM_TYPE_DECIMAL = "BigDecimal";
    public static final String NUM_TYPE_BLOB = "Blob";
    public static final String DATE_TYPE = "Date";
    public static final String DATE_TIME_TYPE = "datetime";
    public static final String TIMESTAMP_TYPE = "Timestamp";
    public static final String SQL_SELECT = "SELECT ";
    public static final String SQL_FROM = " FROM ";
    public static final String SQL_AND = " AND ";
    public static final String SQL_LIKE = " like ";
    public static final String SQL_COUNT = " COUNT(*) ";
    public static final String SQL_WHERE_TRUE = " where 1=1  ";
    public static final String SQL_WHERE = " where  ";
    public static final String SQL_ORDER = " ORDER BY ";
    public static final String SQL_ASC = "asc";
    public static final String SQL_DESC = "desc";
    public static final String SQL_EQ = "=";
    public static final String SQL_NE = "!=";
    public static final String SQL_GE = ">=";
    public static final String SQL_GT = ">";
    public static final String SQL_LE = "<=";
    public static final String SQL_LT = "<";
    public static final String SQL_OR = " or ";
    public static final String SQL_SQ = "'";
    public static final String SQLERVER_ZH = "N";
    public static final String SQL_COMMA = ",";
    public static final String P_KEY = "id_";
    public static final String BUSINESS_KEY = "business_key";
    public static final String ONLINE_TABLE_SPLIT_STR = "$";

    public static boolean isNumField(String dbtype) {
        return NUM_TYPE_INT.equals(dbtype) || NUM_TYPE_DOUBLE.equals(dbtype) || NUM_TYPE_DECIMAL.equals(dbtype) || NUM_TYPE_INTEGER.equals(dbtype);
    }

    public static boolean isDateField(String dbtype) {
        return DATE_TYPE.equalsIgnoreCase(dbtype) || DATE_TIME_TYPE.equalsIgnoreCase(dbtype) || TIMESTAMP_TYPE.equalsIgnoreCase(dbtype);
    }

    public static String getRealTableName(String tablename) {
        if (Pattern.matches("^[a-zA-z].*\\$\\d+$", tablename)) {
            return tablename.substring(0, tablename.lastIndexOf(ONLINE_TABLE_SPLIT_STR));
        }
        return tablename;
    }

    public static String initMybatisValueWithJdbcType(String dataBase, FormBusinessModelColumnEntity item, JsonNode json, Map<String, Object> params) {
        String dbType = item.getDataType();
        String field = item.getColumnKey();
        if (json.get(field) == null) {
            return "null";
        }
        JsonNode jsonNode = json.get(field);
        if (NUM_TYPE_INT.equals(dbType)) {
            params.put(field, jsonNode.asInt());
            return "#{" + field + ",jdbcType=INTEGER}";
        }
        if (NUM_TYPE_DOUBLE.equals(dbType)) {
            params.put(field, jsonNode.asDouble());
            return "#{" + field + ",jdbcType=DOUBLE}";
        }
        if (NUM_TYPE_DECIMAL.equals(dbType)) {
            params.put(field, new BigDecimal(jsonNode.asDouble()));
            return "#{" + field + ",jdbcType=DECIMAL}";
        }
        if (NUM_TYPE_BLOB.equals(dbType)) {
            params.put(field, jsonNode.asText());
            return "#{" + field + ",jdbcType=BLOB}";
        }
        if (DATE_TYPE.equals(dbType)) {
            String fieldVal = jsonNode.asText();
            params.put(field, fieldVal);
            return "#{" + field + "}";
        }
        if (DATE_TYPE.equalsIgnoreCase(dbType)) {
            String format = item.getFormat();
            String fieldVal = jsonNode.asText();
            if (StringUtil.isEmpty((String)fieldVal)) {
                fieldVal = DateUtils.getCurrent();
            }
            params.put(field, fieldVal);
            return "#{" + field + "}";
        }
        params.put(field, jsonNode.asText());
        return "#{" + field + ",jdbcType=VARCHAR}";
    }
}

