/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.resource;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.pangubpm.common.annotation.SysLog;
import com.pangubpm.common.config.PanguProperties;
import com.pangubpm.common.utils.DateUtils;
import com.pangubpm.common.utils.Result;
import com.pangubpm.common.utils.SnowflakeIdWorkerUtils;
import com.pangubpm.common.web.AbstractController;
import com.pangubpm.modules.form.entity.FormCustomDialogWithBLOBs;
import com.pangubpm.modules.form.entity.TableMetaDataEntity;
import com.pangubpm.modules.form.query.FormCustomDialogQuery;
import com.pangubpm.modules.form.service.FormCustomDialogService;
import com.pangubpm.modules.form.service.MetadataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/form/customDialog/"})
@Api(tags={"\u8868\u5355\u5bf9\u8bdd\u6846\u76f8\u5173\u63a5\u53e3"})
public class FormCustomDialogController
extends AbstractController {
    @Autowired
    private FormCustomDialogService formCustomDialogService;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private PanguProperties panguProperties;

    @GetMapping(value={"list"})
    public String list() throws Exception {
        return "modules/form/customDialogList";
    }

    @RequestMapping(value={"listJson"})
    @ResponseBody
    public Result listJson(@ApiIgnore @RequestParam Map<String, Object> params, FormCustomDialogQuery formCustomDialogQuery) {
        return this.formCustomDialogService.queryPage(params, formCustomDialogQuery);
    }

    @GetMapping(value={"detail"})
    public String customQueryDetail(Model model, @ApiIgnore @RequestParam Map<String, Object> allRequestParams) throws Exception {
        Object id = allRequestParams.get("id");
        if (id != null && StringUtils.isNotEmpty((CharSequence)id.toString())) {
            model.addAttribute("id", (Object)id.toString());
        }
        return "modules/form/customDialogDetail";
    }

    @GetMapping(value={"metadataInfo/{key}"})
    @ResponseBody
    public Result queryMetaTable(Model model, @PathVariable String key) throws Exception {
        String tenantId = this.getTenantId();
        List<TableMetaDataEntity> tableMetaDataEntities = this.metadataService.queryAllTable(key, tenantId);
        return Result.ok().put("data", tableMetaDataEntities);
    }

    @GetMapping(value={"/data"})
    public String tableEditBak() {
        return "modules/form/customDialogEdit";
    }

    @GetMapping(value={"/data/rest"})
    public String restData() {
        return "modules/form/dataEditRest";
    }

    @PostMapping(value={"save"})
    @SysLog(value="\u4fdd\u5b58\u8868\u5355\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846")
    @ResponseBody
    public Result save(HttpServletRequest request, FormCustomDialogWithBLOBs formCustomQueryWithBLOBs) throws Exception {
        String id = formCustomQueryWithBLOBs.getId();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            formCustomQueryWithBLOBs.setUpdateTime(DateUtils.getCurrentDate());
            this.formCustomDialogService.updateById(formCustomQueryWithBLOBs);
        } else {
            id = SnowflakeIdWorkerUtils.getNextId();
            formCustomQueryWithBLOBs.setId(id);
            String userId = this.getUserId(request);
            formCustomQueryWithBLOBs.setCreateTime(DateUtils.getCurrentDate());
            formCustomQueryWithBLOBs.setUpdateTime(DateUtils.getCurrentDate());
            this.formCustomDialogService.saveAndCeateJson(userId, formCustomQueryWithBLOBs);
        }
        return Result.ok();
    }

    @GetMapping(value={"/get/{id}"})
    @ResponseBody
    public Result get(@PathVariable String id) {
        return this.formCustomDialogService.getById(id);
    }

    @RequestMapping(value={"/get/alia/{alia}"})
    @ResponseBody
    public Result getByAlia(@PathVariable String alia, @RequestParam Map<String, Object> params) {
        return this.formCustomDialogService.queryPageByAlia(alia, params);
    }

    @SysLog(value="\u6839\u636e\u522b\u540d\u67e5\u8be2\u5bf9\u8bdd\u6846\u5b57\u6bb5")
    @GetMapping(value={"/get/code/{alia}"})
    @ResponseBody
    @ApiOperation(value="\u6839\u636e\u522b\u540d\u67e5\u8be2\u5bf9\u8bdd\u6846\u5b57\u6bb5", tags={"\u6839\u636e\u522b\u540d\u67e5\u8be2\u5bf9\u8bdd\u6846\u5b57\u6bb5"}, notes="\u6839\u636e\u522b\u540d\u67e5\u8be2\u5bf9\u8bdd\u6846\u5b57\u6bb5", httpMethod="GET")
    public Result getByCode(@PathVariable String alia) {
        return this.formCustomDialogService.getByAlia(alia);
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public Result delete(@RequestParam(value="ids[]") String[] ids) {
        Result r = Result.ok();
        if (!Boolean.valueOf(this.panguProperties.getPanguDelete()).booleanValue()) {
            return Result.error((String)"\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        this.formCustomDialogService.removeByIds(Arrays.asList(ids));
        return r;
    }

    @PostMapping(value={"/remove"})
    @SysLog(value="\u6279\u91cf\u5220\u9664\u5bf9\u8bdd\u6846")
    @ResponseBody
    public Result removeByIds(@RequestBody JSONObject jsonParam) {
        JSONArray list = jsonParam.getJSONArray("ids");
        if (list.size() == 0) {
            return Result.error((String)"\u6ca1\u6709\u9009\u4e2d\u6570\u636e");
        }
        if (Boolean.valueOf(this.panguProperties.getPanguDelete()).booleanValue()) {
            this.formCustomDialogService.removeByIds((List<String>)list);
            return Result.ok();
        }
        return Result.error((String)"\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
    }
}

