/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.resource;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.pangubpm.common.annotation.SysLog;
import com.pangubpm.common.config.PanguProperties;
import com.pangubpm.common.utils.Query;
import com.pangubpm.common.utils.Result;
import com.pangubpm.common.utils.SnowflakeIdWorkerUtils;
import com.pangubpm.common.utils.StringUtil;
import com.pangubpm.common.web.AbstractController;
import com.pangubpm.modules.form.exception.BusinessException;
import com.pangubpm.modules.form.model.FormDefinition;
import com.pangubpm.modules.form.query.FormDefinitionQuery;
import com.pangubpm.modules.form.service.FormDesignService;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/form/design/"})
public class FormDesignResource
extends AbstractController {
    @Autowired
    private PanguProperties panguProperties;
    @Autowired
    private FormDesignService formDesignService;

    public String businessTableList() {
        return "modules/form/busQuery";
    }

    @GetMapping(value={"list"})
    public String list() throws Exception {
        return "modules/form/designList";
    }

    @GetMapping(value={"add"})
    public String designAdd() throws Exception {
        return "modules/form/designAdd";
    }

    @GetMapping(value={"version/{key}"})
    public String version(@PathVariable(value="key") String key, Model model) throws Exception {
        model.addAttribute("modelKey", (Object)key);
        return "modules/form/version";
    }

    @GetMapping(value={"editor/{id}"})
    public String editor(@PathVariable(value="id") String id) throws Exception {
        return "redirect:/form/index.html#/?id=" + id;
    }

    @PostMapping(value={"save"})
    @SysLog(value="\u4fdd\u5b58\u4e1a\u52a1\u8868\u5355")
    public String designAdd(HttpServletRequest request, FormDefinition formDefinition) throws Exception {
        String id = SnowflakeIdWorkerUtils.getNextId();
        formDefinition.setId(id);
        String userId = this.getUserId(request);
        String formKey = formDefinition.getFormKey();
        if (StringUtil.isEmpty((String)formKey)) {
            throw new BusinessException("\u8868\u5355Key\u5fc5\u586b");
        }
        List<FormDefinition> formDefinitionList = this.formDesignService.getByFormKey(formKey);
        if (formDefinitionList.size() > 0) {
            throw new BusinessException("\u8868\u5355Key\u4e0d\u80fd\u91cd\u590d");
        }
        this.formDesignService.saveAndCreateJson(userId, formDefinition);
        return "redirect:/form/index.html#/?id=" + id;
    }

    @PostMapping(value={"json/update/{formKey}"})
    @SysLog(value="\u6839\u636e\u6d41\u7a0bkey\u66f4\u65b0\u6240\u6709\u8868\u5355\u6a21\u677f")
    @ResponseBody
    public Result updateModelJson(@PathVariable String formKey, @RequestBody JSONObject jsonParam) {
        JSONArray list = jsonParam.getJSONArray("ids");
        return this.formDesignService.updateModelJson(formKey, (List)list);
    }

    @PostMapping(value={"/version/get/{formKey}"})
    @SysLog(value="\u6839\u636e\u6d41\u7a0bkey\u83b7\u53d6\u6240\u6709\u7248\u672c\u7684\u8868\u5355\u6a21\u578b")
    @ResponseBody
    public Result getAllVersionFormModel(@PathVariable String formKey) {
        return this.formDesignService.getAllVersionFormModel(formKey);
    }

    @PostMapping(value={"json/save"})
    @SysLog(value="\u4fdd\u5b58\u4e1a\u52a1\u8868\u5355")
    @ResponseBody
    public Result designAddJson(HttpServletRequest request, FormDefinition formDefinition) {
        String id = SnowflakeIdWorkerUtils.getNextId();
        formDefinition.setId(id);
        String userId = this.getUserId(request);
        String formKey = formDefinition.getFormKey();
        if (StringUtil.isEmpty((String)formKey)) {
            throw new BusinessException("\u8868\u5355Key\u5fc5\u586b");
        }
        List<FormDefinition> formDefinitionList = this.formDesignService.getByFormKey(formKey);
        if (formDefinitionList.size() > 0) {
            throw new BusinessException("\u8868\u5355Key\u4e0d\u80fd\u91cd\u590d");
        }
        this.formDesignService.saveAndCreateJson(userId, formDefinition);
        return Result.ok().put("id", (Object)id);
    }

    @PostMapping(value={"saveJson/{id}"})
    @SysLog(value="\u67e5\u8be2\u4e1a\u52a1\u8868\u5355")
    @ResponseBody
    public Result saveJson(HttpServletRequest request, @PathVariable(value="id") String id, String jsonStr) throws Exception {
        jsonStr = URLDecoder.decode(jsonStr, "UTF-8");
        return this.formDesignService.saveJson(this.getUserId(request), id, jsonStr);
    }

    @RequestMapping(value={"models/listJson"})
    @ResponseBody
    @SysLog(value="\u67e5\u8be2\u4e1a\u52a1\u8868\u5355")
    public Result listJson(@RequestParam Map<String, Object> params, FormDefinitionQuery formDefinitionQuery) {
        IPage page = new Query().getPage(params);
        Result r = this.formDesignService.list((IPage<FormDefinition>)page, params, formDefinitionQuery);
        return r;
    }

    @RequestMapping(value={"models/listAll"})
    @SysLog(value="\u67e5\u8be2\u4e1a\u52a1\u8868\u5355")
    @ResponseBody
    public Result listAll(@RequestParam Map<String, Object> params) {
        IPage page = new Query().getPage(params);
        Result r = this.formDesignService.listAll((IPage<FormDefinition>)page, params);
        return r;
    }

    @GetMapping(value={"remove/{id}"})
    @SysLog(value="\u5220\u9664\u4e1a\u52a1\u8868\u5355")
    @ResponseBody
    public Result remove(@PathVariable(value="id") String id) throws Exception {
        if (Boolean.valueOf(this.panguProperties.getPanguDelete()).booleanValue()) {
            return this.formDesignService.remove(id);
        }
        return Result.error((String)"\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
    }

    @PostMapping(value={"models/updateMain"})
    @SysLog(value="\u66f4\u65b0\u4e1a\u52a1\u8868\u5355")
    @ResponseBody
    public Result updateMain(String modelId) {
        Result r = this.formDesignService.updateMain(modelId);
        return r;
    }

    @GetMapping(value={"models/publish/{id}"})
    @SysLog(value="\u53d1\u5e03\u4e1a\u52a1\u8868\u5355")
    @ResponseBody
    public Result publish(@PathVariable(value="id") String id) throws Exception {
        return this.formDesignService.publish(id);
    }
}

