/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pangu.form.api.FormDeployment;
import com.pangu.form.api.FormRepositoryService;
import com.pangu.form.engine.FormEngineConfiguration;
import com.pangu.form.engine.impl.persistence.entity.FormDefinitionEntityImpl;
import com.pangubpm.common.utils.DateUtils;
import com.pangubpm.common.utils.PageUtils;
import com.pangubpm.common.utils.Result;
import com.pangubpm.common.utils.SnowflakeIdWorkerUtils;
import com.pangubpm.common.utils.StringUtil;
import com.pangubpm.form.model.FormConfig;
import com.pangubpm.form.model.SqlType;
import com.pangubpm.form.model.original.SimpleOriginalFormModel;
import com.pangubpm.form.model.original.field.BaseOriginalFormField;
import com.pangubpm.form.model.original.options.BaseFieldOptions;
import com.pangubpm.form.model.original.options.BlockFieldOptions;
import com.pangubpm.form.model.original.options.TableFieldOptions;
import com.pangubpm.form.model.original.options.date.DateDateFieldOptions;
import com.pangubpm.form.model.original.options.date.TimeDateFieldOptions;
import com.pangubpm.form.model.original.options.text.InputFieldOptions;
import com.pangubpm.modules.form.constant.BusTableRelType;
import com.pangubpm.modules.form.constant.FormDefStatusEnum;
import com.pangubpm.modules.form.dao.FormBusinessModelColumnDao;
import com.pangubpm.modules.form.dao.FormDefinitionDao;
import com.pangubpm.modules.form.dto.FormGroupModelDto;
import com.pangubpm.modules.form.dto.FormModelDto;
import com.pangubpm.modules.form.entity.FormBusObject;
import com.pangubpm.modules.form.entity.FormBusinessModelColumnEntity;
import com.pangubpm.modules.form.exception.BusinessException;
import com.pangubpm.modules.form.model.BusTableRel;
import com.pangubpm.modules.form.model.FormDefinition;
import com.pangubpm.modules.form.query.FormDefinitionQuery;
import com.pangubpm.modules.form.service.FormBusObjectService;
import com.pangubpm.modules.form.service.FormDesignService;
import com.pangubpm.modules.form.utils.FillDataUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.util.ThreadMapUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="formDesignService")
public class FormDesignServiceImpl
extends ServiceImpl<FormDefinitionDao, FormDefinition>
implements FormDesignService {
    @Autowired
    private FormDefinitionDao formDefinitionDao;
    @Autowired
    private FormBusObjectService formBusObjectService;
    @Autowired
    private FormBusinessModelColumnDao formBusinessModelColumnDao;
    @Autowired
    private FormEngineConfiguration formEngineConfiguration;

    public boolean save(FormDefinition entity) {
        return this.formDefinitionDao.insert(entity) > 0;
    }

    @Override
    public Result updateModelJson(String formKey, List list) {
        Result r = Result.ok();
        List<FormDefinition> formDefinitions = this.getByFormKey(formKey);
        if (formDefinitions == null && formDefinitions.size() == 0) {
            r = Result.error((String)"\u8868\u5355\u6a21\u578b\u4e0d\u5b58\u5728");
        }
        List deploymentIds = formDefinitions.stream().map(FormDefinition::getDeploymentId).distinct().collect(Collectors.toList());
        FormDefinition formDefinition = formDefinitions.get(0);
        SimpleOriginalFormModel simpleOriginalFormModel = new SimpleOriginalFormModel();
        this.generateConfig(formDefinition.getName(), simpleOriginalFormModel);
        this.generateList(formDefinition, simpleOriginalFormModel);
        ObjectMapper objectMapper = new ObjectMapper();
        String form = null;
        try {
            form = objectMapper.writeValueAsString((Object)simpleOriginalFormModel);
            if (StringUtil.isNotEmpty((String)form)) {
                this.formDefinitionDao.updateFormJsonBatchByKey(formKey, form.getBytes("UTF-8"), list);
                FormRepositoryService formRepositoryService = this.formEngineConfiguration.getFormRepositoryService();
                formRepositoryService.batchUpdateDeploymentResource(deploymentIds, form.getBytes("UTF-8"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    @Override
    public Result getAllVersionFormModel(String formKey) {
        List<FormDefinition> formDefinitionsList = this.getByFormKey(formKey);
        return Result.ok().put("data", formDefinitionsList);
    }

    @Override
    public boolean deployForm(String formValue, String type, String parentDeployId, String formJsonStr) {
        FormDefinition formDefinition;
        if (StringUtils.isNotEmpty((CharSequence)type) && type.equals("frame") && (formDefinition = this.getByMainKey(formValue)) != null) {
            this.publish(formDefinition, parentDeployId, formJsonStr);
        }
        return true;
    }

    public Result publish(FormDefinition formDefinition, String parentDeployId, String formJsonStr) {
        FormRepositoryService formRepositoryService = this.formEngineConfiguration.getFormRepositoryService();
        this.formDefinitionDao.updateBatchByKey(formDefinition.getFormKey(), "0");
        byte[] pageFormJson = formDefinition.getPageFormJson();
        String formDefinitionStr = null;
        try {
            formDefinitionStr = new String(pageFormJson, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String resourceName = formDefinition.getFormKey() + ".form";
        FormDefinitionEntityImpl formDefinitionEntity = new FormDefinitionEntityImpl();
        formDefinitionEntity.setResourceName(resourceName);
        formDefinitionEntity.setKey(formDefinition.getFormKey());
        formDefinitionEntity.setName(formDefinition.getName());
        formDefinitionEntity.setCategory(formDefinition.getGroupId());
        ThreadMapUtil.put((String)"formDefinitionEntity", (Object)formDefinitionEntity);
        FormDeployment fd = formRepositoryService.createDeployment().addFormDefinition(resourceName, formDefinitionStr).parentDeploymentId(parentDeployId).deploy();
        String deploymentId = fd.getId();
        com.pangu.form.api.FormDefinition formDefinition1 = (com.pangu.form.api.FormDefinition)formRepositoryService.createFormDefinitionQuery().deploymentId(deploymentId).formDefinitionKey(formDefinition.getFormKey()).formResourceName(resourceName).singleResult();
        formDefinition.setIsMain(true);
        String nextId = SnowflakeIdWorkerUtils.getNextId();
        formDefinition.setId(nextId);
        formDefinition.setIsMain(true);
        formDefinition.setCreateTime(DateUtils.getCurrentDate());
        formDefinition.setVersion(Integer.valueOf(formDefinition1.getVersion()));
        formDefinition.setDefId(formDefinition1.getId());
        formDefinition.setDeploymentId(deploymentId);
        formDefinition.setStatus(FormDefStatusEnum.DEPLOY.getStatus());
        formDefinition.setFormHtml(formJsonStr.getBytes(StandardCharsets.UTF_8));
        this.save(formDefinition);
        return Result.ok();
    }

    @Override
    public void saveAndCreateJson(String userId, FormDefinition formDefinition) {
        SimpleOriginalFormModel simpleOriginalFormModel = new SimpleOriginalFormModel();
        this.generateConfig(formDefinition.getName(), simpleOriginalFormModel);
        this.generateList(formDefinition, simpleOriginalFormModel);
        ObjectMapper objectMapper = new ObjectMapper();
        String string = null;
        try {
            string = objectMapper.writeValueAsString((Object)simpleOriginalFormModel);
            try {
                formDefinition.setPageFormJson(string.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            formDefinition.setStatus(FormDefStatusEnum.DRAFT.getStatus());
            formDefinition.setCreateTime(DateUtils.getCurrentDate());
            formDefinition.setUpdateTime(DateUtils.getCurrentDate());
            formDefinition.setCreateBy(userId);
            formDefinition.setIsMain(true);
            this.save(formDefinition);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Result saveJson(String userId, String id, String jsonStr) {
        FormDefinition formDefinition = (FormDefinition)this.getById((Serializable)((Object)id));
        try {
            formDefinition.setPageFormJson(jsonStr.getBytes("UTF-8"));
            formDefinition.setUpdateBy(userId);
            formDefinition.setUpdateTime(DateUtils.getCurrentDate());
            this.updateById(formDefinition);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return Result.ok();
    }

    @Override
    public Result listJson(Map<String, Object> allRequestParams) {
        return null;
    }

    @Override
    public PageUtils queryPage(Map<String, Object> params) {
        return null;
    }

    @Override
    public Result list(IPage<FormDefinition> page, Map<String, Object> params, FormDefinitionQuery formDefinitionQuery) {
        IPage<FormDefinition> formBusinessEntities = this.formDefinitionDao.list(page, params, formDefinitionQuery);
        List records = formBusinessEntities.getRecords();
        return Result.ok().put("count", (Object)formBusinessEntities.getTotal()).put("data", (Object)records);
    }

    @Override
    public Result publish(String id) {
        FormRepositoryService formRepositoryService = this.formEngineConfiguration.getFormRepositoryService();
        FormDefinition formDefinition = (FormDefinition)this.getById((Serializable)((Object)id));
        byte[] pageFormJson = formDefinition.getPageFormJson();
        String formDefinitionStr = null;
        try {
            formDefinitionStr = new String(pageFormJson, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String resourceName = formDefinition.getFormKey() + ".form";
        FormDefinitionEntityImpl formDefinitionEntity = new FormDefinitionEntityImpl();
        formDefinitionEntity.setResourceName(resourceName);
        formDefinitionEntity.setKey(formDefinition.getFormKey());
        formDefinitionEntity.setName(formDefinition.getName());
        formDefinitionEntity.setCategory(formDefinition.getGroupId());
        ThreadMapUtil.put((String)"formDefinitionEntity", (Object)formDefinitionEntity);
        FormDeployment fd = formRepositoryService.createDeployment().addFormDefinition(resourceName, formDefinitionStr).deploy();
        String deploymentId = fd.getId();
        com.pangu.form.api.FormDefinition formDefinition1 = (com.pangu.form.api.FormDefinition)formRepositoryService.createFormDefinitionQuery().deploymentId(deploymentId).formDefinitionKey(formDefinition.getFormKey()).formResourceName(resourceName).singleResult();
        formDefinition.setIsMain(false);
        this.updateById(formDefinition);
        String nextId = SnowflakeIdWorkerUtils.getNextId();
        formDefinition.setId(nextId);
        formDefinition.setIsMain(true);
        formDefinition.setCreateTime(DateUtils.getCurrentDate());
        formDefinition.setVersion(Integer.valueOf(formDefinition1.getVersion()));
        formDefinition.setDefId(formDefinition1.getId());
        formDefinition.setDeploymentId(deploymentId);
        formDefinition.setStatus(FormDefStatusEnum.DEPLOY.getStatus());
        this.save(formDefinition);
        return Result.ok();
    }

    @Override
    public Result listAll(IPage<FormDefinition> page, Map<String, Object> params) {
        IPage<FormDefinition> formBusinessEntities = this.formDefinitionDao.listAll(page, params);
        List records = formBusinessEntities.getRecords();
        return Result.ok().put("count", (Object)formBusinessEntities.getTotal()).put("data", (Object)records);
    }

    @Override
    public Result updateMain(String modelId) {
        FormDefinition formDefinition = (FormDefinition)this.getById((Serializable)((Object)modelId));
        String formKey = formDefinition.getFormKey();
        this.formDefinitionDao.updateBatchByKey(formKey, "0");
        formDefinition.setIsMain(true);
        this.updateById(formDefinition);
        return Result.ok();
    }

    @Override
    public Result remove(String id) {
        Result r = Result.ok();
        FormDefinition formDefinition = (FormDefinition)this.getById((Serializable)((Object)id));
        if (formDefinition == null) {
            r = Result.error((String)"id\u4e0d\u5b58\u5728");
        } else {
            boolean main = formDefinition.isMain();
            if (main) {
                r = Result.error((String)"\u4e3b\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664");
            } else {
                this.removeById((Serializable)((Object)id));
            }
        }
        return r;
    }

    @Override
    public FormDefinition getByMainKey(String formValue) {
        return this.formDefinitionDao.getByMainKey(formValue);
    }

    @Override
    public List<FormDefinition> getByFormKey(String formKey) {
        return this.formDefinitionDao.getByFormKey(formKey);
    }

    @Override
    public Result queryModelListCount() {
        List<FormModelDto> formModelDtoList = this.formDefinitionDao.queryModelListCount();
        Map<Integer, FormModelDto> monthToCount = formModelDtoList.stream().collect(Collectors.toMap(FormModelDto::getMonth, FormModelDto2 -> FormModelDto2));
        ArrayList<FormModelDto> result = new ArrayList<FormModelDto>();
        FillDataUtils.fillData(monthToCount, result);
        return Result.ok().put("formModelCount", result);
    }

    @Override
    public Result getModelListGroupCount() {
        List<FormGroupModelDto> formModelDtoList = this.formDefinitionDao.getModelListGroupCount();
        return Result.ok().put("formModelGroupCount", formModelDtoList);
    }

    private void generateList(FormDefinition formDefinition, SimpleOriginalFormModel simpleOriginalFormModel) {
        String formBusinessId = formDefinition.getFormBusinessId();
        ArrayList<BaseOriginalFormField> list = new ArrayList<BaseOriginalFormField>();
        if (!StringUtils.isNotEmpty((CharSequence)formBusinessId)) {
            throw new IllegalArgumentException("\u4e1a\u52a1\u5bf9\u8c61\u6ca1\u6709\u9009\u62e9");
        }
        FormBusObject bus = this.formBusObjectService.getById(formBusinessId);
        BusTableRel relation = bus.getRelation();
        this.get(list, relation);
        simpleOriginalFormModel.setList(list);
    }

    private void get(List<BaseOriginalFormField> list, BusTableRel relation) {
        if (relation == null) {
            throw new BusinessException("\u5173\u7cfb\u4e0d\u5b58\u5728");
        }
        String tableKey = relation.getTableKey();
        this.fill(tableKey, BusTableRelType.MAIN.getKey(), list, null);
        relation.getChildren().forEach(children -> {
            String childrenTableKey = children.getTableKey();
            String tableComment = children.getTableComment();
            String tableType = children.getType();
            if (BusTableRelType.ONE_TO_ONE.equalsWithKey(tableType)) {
                List<BaseOriginalFormField> baseOriginalFormFields = this.fillBaseOriginalFormField(childrenTableKey, BusTableRelType.ONE_TO_ONE);
                BaseOriginalFormField baseOriginalFormField = new BaseOriginalFormField();
                baseOriginalFormField.setRules(null);
                baseOriginalFormField.setModel(childrenTableKey);
                baseOriginalFormField.setKey(childrenTableKey);
                baseOriginalFormField.setName(tableComment);
                SqlType sqlType = this.getIconAndType("block", baseOriginalFormField);
                BlockFieldOptions baseFieldOptions = new BlockFieldOptions();
                BaseFieldOptions option = this.getOption(SqlType.BLOCK, baseOriginalFormField, null);
                baseOriginalFormField.setOptions(option);
                baseOriginalFormField.setOptions((BaseFieldOptions)baseFieldOptions);
                baseOriginalFormField.setTableColumns(baseOriginalFormFields);
                list.add(baseOriginalFormField);
            } else if (BusTableRelType.ONE_TO_MANY.equalsWithKey(tableType)) {
                List<BaseOriginalFormField> baseOriginalFormFields = this.fillBaseOriginalFormField(childrenTableKey, BusTableRelType.ONE_TO_MANY);
                BaseOriginalFormField baseOriginalFormField = new BaseOriginalFormField();
                baseOriginalFormField.setRules(null);
                baseOriginalFormField.setModel(childrenTableKey);
                baseOriginalFormField.setKey(childrenTableKey);
                baseOriginalFormField.setName(tableComment);
                SqlType sqlType = this.getIconAndType("table", baseOriginalFormField);
                BlockFieldOptions baseFieldOptions = new BlockFieldOptions();
                BaseFieldOptions option = this.getOption(SqlType.TABLE, baseOriginalFormField, null);
                baseOriginalFormField.setOptions(option);
                baseOriginalFormField.setOptions((BaseFieldOptions)baseFieldOptions);
                baseOriginalFormField.setTableColumns(baseOriginalFormFields);
                list.add(baseOriginalFormField);
            }
        });
    }

    private void fill(String tableKey, String tableType, List<BaseOriginalFormField> list, String comment) {
        if (tableType.equals(BusTableRelType.ONE_TO_ONE.getKey())) {
            List<BaseOriginalFormField> baseOriginalFormFields = this.fillBaseOriginalFormField(tableKey, BusTableRelType.ONE_TO_ONE);
            list.addAll(baseOriginalFormFields);
        } else if (tableType.equals(BusTableRelType.MAIN.getKey())) {
            List<BaseOriginalFormField> baseOriginalFormFields = this.fillBaseOriginalFormField(tableKey, BusTableRelType.MAIN);
            list.addAll(baseOriginalFormFields);
        } else if (tableType.equals(BusTableRelType.ONE_TO_MANY.getKey())) {
            List<BaseOriginalFormField> baseOriginalFormFields = this.fillBaseOriginalFormField(tableKey, BusTableRelType.ONE_TO_MANY);
            list.addAll(baseOriginalFormFields);
        }
    }

    private List<BaseOriginalFormField> fillBaseOriginalFormField(String tableKey, BusTableRelType busTableRelType) {
        ArrayList<BaseOriginalFormField> list = new ArrayList<BaseOriginalFormField>();
        List<FormBusinessModelColumnEntity> formBusinessModelColumnEntities = this.formBusinessModelColumnDao.selectByTableKey(tableKey);
        formBusinessModelColumnEntities.forEach(column -> {
            String dataType = column.getDataType();
            String id = column.getId();
            String description = column.getDescription();
            String defaultValue = column.getDefaultValue();
            String name = column.getName();
            String columnKey = column.getColumnKey();
            BaseOriginalFormField baseOriginalFormField = new BaseOriginalFormField();
            baseOriginalFormField.setRules(null);
            baseOriginalFormField.setModel(columnKey);
            baseOriginalFormField.setKey(columnKey);
            baseOriginalFormField.setName(description);
            SqlType sqlType = this.getIconAndType(dataType, baseOriginalFormField);
            BaseFieldOptions option = this.getOption(sqlType, baseOriginalFormField, (FormBusinessModelColumnEntity)column);
            baseOriginalFormField.setOptions(option);
            list.add(baseOriginalFormField);
        });
        return list;
    }

    private BaseFieldOptions getOption(SqlType sqlType, BaseOriginalFormField baseOriginalFormField, FormBusinessModelColumnEntity column) {
        InputFieldOptions baseFieldOptions = null;
        if (sqlType == SqlType.INPUT || sqlType == SqlType.NUMBER) {
            baseFieldOptions = new InputFieldOptions();
            baseFieldOptions.setDefaultValue(column.getDefaultValue());
        } else if (sqlType == SqlType.DATE) {
            baseFieldOptions = new DateDateFieldOptions();
            ((DateDateFieldOptions)baseFieldOptions).setDefaultValue(column.getDefaultValue());
            ((DateDateFieldOptions)baseFieldOptions).setTimestamp(true);
            ((DateDateFieldOptions)baseFieldOptions).setType("datetime");
            ((DateDateFieldOptions)baseFieldOptions).setFormat("yyyy-MM-dd HH:mm:ss");
        } else if (sqlType == SqlType.TIME) {
            baseFieldOptions = new TimeDateFieldOptions();
            ((TimeDateFieldOptions)baseFieldOptions).setDefaultValue(column.getDefaultValue());
        } else if (sqlType == SqlType.BLOCK) {
            baseFieldOptions = new BlockFieldOptions();
        } else if (sqlType == SqlType.TABLE) {
            baseFieldOptions = new TableFieldOptions();
        }
        baseOriginalFormField.setOptions((BaseFieldOptions)baseFieldOptions);
        return baseFieldOptions;
    }

    private SqlType getIconAndType(String dataType, BaseOriginalFormField baseOriginalFormField) {
        SqlType sqlType = SqlType.getBySqlType((String)dataType);
        baseOriginalFormField.setIcon(sqlType.getIcon());
        baseOriginalFormField.setType(sqlType.getType());
        return sqlType;
    }

    private FormConfig generateConfig(String formName, SimpleOriginalFormModel simpleOriginalFormModel) {
        FormConfig formConfig = new FormConfig();
        formConfig.setFormName(formName);
        simpleOriginalFormModel.setConfig(formConfig);
        return formConfig;
    }
}

