/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.pangubpm.common.db.exception.DBException;
import com.pangubpm.common.db.operate.DbTypeOperate;
import com.pangubpm.common.db.util.oConvertUtils;
import com.pangubpm.common.entity.Result;
import com.pangubpm.common.utils.DateUtils;
import com.pangubpm.common.utils.SnowflakeIdWorkerUtils;
import com.pangubpm.common.utils.StringUtil;
import com.pangubpm.modules.db.entity.CgformConfigModel;
import com.pangubpm.modules.db.entity.FormDataBaseConfig;
import com.pangubpm.modules.db.utils.DbTableProcess;
import com.pangubpm.modules.form.constant.PanGuColumnType;
import com.pangubpm.modules.form.dao.FormBusinessDao;
import com.pangubpm.modules.form.dao.FormBusinessModelColumnDao;
import com.pangubpm.modules.form.dao.MySQLGeneratorDao;
import com.pangubpm.modules.form.dto.FormGroupModelDto;
import com.pangubpm.modules.form.dto.FormModelDto;
import com.pangubpm.modules.form.entity.FormBusObject;
import com.pangubpm.modules.form.entity.FormBusinessEntity;
import com.pangubpm.modules.form.entity.FormBusinessModelColumnEntity;
import com.pangubpm.modules.form.entity.FormModelVO;
import com.pangubpm.modules.form.handler.DbHandler;
import com.pangubpm.modules.form.query.FormBusinessQuery;
import com.pangubpm.modules.form.service.FormBusObjectService;
import com.pangubpm.modules.form.service.FormBusinessService;
import com.pangubpm.modules.form.utils.FillDataUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="formBusinessService")
public class FormBusinessServiceImpl
extends ServiceImpl<FormBusinessDao, FormBusinessEntity>
implements FormBusinessService {
    private static ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private FormBusObjectService formBusObjectService;
    @Autowired
    private FormBusinessDao formBusinessDao;
    @Autowired
    private FormBusinessModelColumnDao formBusinessModelColumnDao;
    @Autowired
    private FormDataBaseConfig dataBaseConfig;
    @Autowired
    private MySQLGeneratorDao mySQLGeneratorDao;

    public com.pangubpm.common.utils.Result listByGroupId(IPage<FormBusinessEntity> page, Map<String, Object> map, FormBusinessQuery formBusinessQuery, String tenantId) {
        IPage<FormBusinessEntity> formBusinessEntities = this.formBusinessDao.listByGroupId(page, map, formBusinessQuery, tenantId);
        List records = formBusinessEntities.getRecords();
        return com.pangubpm.common.utils.Result.ok().put("count", (Object)formBusinessEntities.getTotal()).put("data", (Object)records);
    }

    public com.pangubpm.common.utils.Result saveOrUpdate(FormModelVO formModelVO, String userId, String tenantId) {
        String tableId;
        FormBusinessEntity formBusinessEntity = formModelVO.getFormBusinessEntity();
        String tableName = formBusinessEntity.getTableName();
        String modelName = formBusinessEntity.getModelName();
        if (StringUtils.isNotEmpty((CharSequence)formBusinessEntity.getId())) {
            this.update(formModelVO, userId);
            tableId = formBusinessEntity.getId();
        } else {
            List<FormBusinessEntity> existFebList = this.formBusinessDao.getByKeyOrModelName(tableName, modelName, tenantId);
            if (!existFebList.isEmpty()) {
                return com.pangubpm.common.utils.Result.error((String)"\u8868\u540d\u6216\u8005\u5b9e\u4f53\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
            }
            tableId = this.save(formModelVO, userId, tenantId);
        }
        return com.pangubpm.common.utils.Result.ok().put("tableId", (Object)tableId);
    }

    private void update(FormModelVO formModelVO, String userId) {
        FormBusinessEntity formBusinessEntity = formModelVO.getFormBusinessEntity();
        this.formBusinessDao.updateByPrimaryKey(formBusinessEntity);
        String tableId = formBusinessEntity.getId();
        List formBusinessModelColumnEntityList = formModelVO.getFormBusinessModelColumnEntityList();
        for (FormBusinessModelColumnEntity fbmc : formBusinessModelColumnEntityList) {
            fbmc.setUpdateBy(userId);
            fbmc.setUpdateTime(DateUtils.getCurrentDate());
            if (StringUtils.isNotEmpty((CharSequence)fbmc.getId())) {
                this.formBusinessModelColumnDao.updateByPrimaryKey(fbmc);
                continue;
            }
            fbmc.setId(SnowflakeIdWorkerUtils.getNextId());
            fbmc.setTableId(tableId);
            fbmc.setCreateBy(userId);
            fbmc.setCreateTime(DateUtils.getCurrentDate());
            this.formBusinessModelColumnDao.insert(fbmc);
        }
    }

    private String save(FormModelVO formModelVO, String userId, String tenantId) {
        FormBusinessEntity formBusinessEntity = formModelVO.getFormBusinessEntity();
        List formBusinessModelColumnEntityList = formModelVO.getFormBusinessModelColumnEntityList();
        String tableId = SnowflakeIdWorkerUtils.getNextId();
        ArrayList<FormBusinessModelColumnEntity> insertBatchList = new ArrayList<FormBusinessModelColumnEntity>(formBusinessModelColumnEntityList.size());
        for (FormBusinessModelColumnEntity fbmc : formBusinessModelColumnEntityList) {
            fbmc.setTableId(tableId);
            fbmc.setCreateBy(userId);
            fbmc.setTenantId(tenantId);
            fbmc.setCreateTime(DateUtils.getCurrentDate());
            fbmc.setId(SnowflakeIdWorkerUtils.getNextId());
            insertBatchList.add(fbmc);
        }
        formBusinessEntity.setId(tableId);
        formBusinessEntity.setCreateBy(userId);
        formBusinessEntity.setTenantId(tenantId);
        formBusinessEntity.setCreateTime(DateUtils.getCurrentDate());
        formBusinessEntity.setUpdateTime(DateUtils.getCurrentDate());
        this.formBusinessDao.save(formBusinessEntity);
        this.formBusinessModelColumnDao.insertBatch(insertBatchList);
        return tableId;
    }

    public com.pangubpm.common.utils.Result getTableAndColumn(String id) {
        FormModelVO tableAndColumns = this.getTableAndColumns(id);
        return com.pangubpm.common.utils.Result.ok().put("data", (Object)tableAndColumns);
    }

    public FormModelVO getTableAndColumns(String id) {
        FormBusinessEntity formBusinessEntity = this.formBusinessDao.selectByTableId(id);
        FormModelVO formModelVO = new FormModelVO();
        formModelVO.setFormBusinessEntity(formBusinessEntity);
        List<FormBusinessModelColumnEntity> formBusinessModelColumnEntities = this.formBusinessModelColumnDao.selectByTableId(id);
        formModelVO.setFormBusinessModelColumnEntityList(this.fillColumn(formBusinessModelColumnEntities));
        return formModelVO;
    }

    public com.pangubpm.common.utils.Result delete(String tableId) {
        this.formBusinessDao.deleteByPrimaryKey(tableId);
        return com.pangubpm.common.utils.Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    public com.pangubpm.common.utils.Result deleteColumnById(String id) {
        this.formBusinessModelColumnDao.deleteById((Serializable)((Object)id));
        return com.pangubpm.common.utils.Result.ok();
    }

    private List<FormBusinessModelColumnEntity> fillColumn(List<FormBusinessModelColumnEntity> formBusinessModelColumnEntities) {
        ArrayList<FormBusinessModelColumnEntity> resultFormBusinessModelColumnEntities = new ArrayList<FormBusinessModelColumnEntity>(formBusinessModelColumnEntities.size());
        for (FormBusinessModelColumnEntity fbmc : formBusinessModelColumnEntities) {
            String dataType = fbmc.getDataType();
            PanGuColumnType byDbDataType = PanGuColumnType.getByDbDataType((String)dataType);
            fbmc.setDataType(byDbDataType.getKey());
            resultFormBusinessModelColumnEntities.add(fbmc);
        }
        return resultFormBusinessModelColumnEntities;
    }

    public com.pangubpm.common.utils.Result queryModelListCount() {
        List<FormModelDto> formModelDtoList = this.formBusinessDao.queryModelListCount();
        Map<Integer, FormModelDto> monthToCount = formModelDtoList.stream().collect(Collectors.toMap(FormModelDto::getMonth, formModelDto -> formModelDto));
        ArrayList<FormModelDto> result = new ArrayList<FormModelDto>();
        FillDataUtils.fillData(monthToCount, result);
        return com.pangubpm.common.utils.Result.ok().put("formModelCount", result);
    }

    public com.pangubpm.common.utils.Result getModelGroupCount() {
        List<FormGroupModelDto> formModelDtoList = this.formBusinessDao.getModelGroupCount();
        return com.pangubpm.common.utils.Result.ok().put("formModelGroupCount", formModelDtoList);
    }

    public void insertBatch(List<FormBusinessEntity> list) {
        this.formBusinessDao.insertBatch(list);
    }

    public List<FormBusinessEntity> queryByIdList(List list) {
        return this.formBusinessDao.queryByIdList(list);
    }

    public com.pangubpm.common.utils.Result dbCreate(String id) {
        FormBusinessEntity formBusinessEntity = this.formBusinessDao.selectByTableId(id);
        if (formBusinessEntity == null) {
            return com.pangubpm.common.utils.Result.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        String tableId = formBusinessEntity.getId();
        List<FormBusinessModelColumnEntity> fieldList = this.formBusinessModelColumnDao.getByTableId(tableId);
        String tableName = formBusinessEntity.getTableName();
        CgformConfigModel model = new CgformConfigModel();
        model.setTableName(tableName);
        model.setColumns(fieldList);
        model.setDbConfig(this.dataBaseConfig);
        DbTableProcess dbTableProcess = null;
        try {
            dbTableProcess = new DbTableProcess();
            boolean bl = dbTableProcess.getDbTableHandle().judgeTableIsExit(tableName);
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Result handlerPhysicalTable(String tableKey, String formKey, String jsonNodeStr, String businessKey, boolean isSave) {
        JsonNode jsonNode = null;
        try {
            jsonNode = objectMapper.readTree(jsonNodeStr);
            if (!(jsonNode instanceof NullNode)) {
                ((ObjectNode)jsonNode).put("business_key", businessKey);
                Map<String, Object> formDataSaveSql = this.getFormDataSaveSql(formKey, jsonNode, businessKey);
                this.mySQLGeneratorDao.executeInsertSQL(formDataSaveSql);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Result();
    }

    public Map<String, Object> getFormDataSaveSql(String modelViewCode, JsonNode json, String processInstanceId) {
        String relationJson;
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        FormBusObject formBusObject = this.formBusObjectService.getBymodelViewCode(modelViewCode);
        if (formBusObject != null && StringUtils.isNotEmpty((CharSequence)(relationJson = formBusObject.getRelationJson()))) {
            JSONObject jsonObject = JSON.parseObject((String)relationJson);
            String mainTableKey = jsonObject.get((Object)"tableKey").toString();
            String dataBase = "";
            String keyFieldValue = null;
            boolean hasKey = false;
            try {
                DbTableProcess dbTableProcess = new DbTableProcess();
                dataBase = DbTypeOperate.getDatabaseType();
                List<FormBusinessModelColumnEntity> fieldList = this.formBusinessModelColumnDao.getByTableName(mainTableKey);
                if (fieldList != null && fieldList.size() > 0) {
                    for (FormBusinessModelColumnEntity item : fieldList) {
                        String key = item.getColumnKey();
                        if (null == key) continue;
                        if ("id_".equals(key.toLowerCase())) {
                            hasKey = true;
                            keyFieldValue = json.get("id_").asText();
                            continue;
                        }
                        if (json.get(key) == null && !"createBy".equalsIgnoreCase(key) && !"createTime".equalsIgnoreCase(key)) continue;
                        sb1.append("," + key);
                        String sqlValue = DbHandler.initMybatisValueWithJdbcType(dataBase, item, json, params);
                        sb2.append("," + sqlValue);
                    }
                    if (!hasKey || oConvertUtils.isEmpty(keyFieldValue)) {
                        keyFieldValue = SnowflakeIdWorkerUtils.getNextId();
                    }
                    String sql = "insert into " + DbHandler.getRealTableName(mainTableKey) + "(" + "id_" + sb1.toString() + ") values(" + "'" + keyFieldValue + "'" + sb2.toString() + ")";
                    params.put("execute_sql_string", sql);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (DBException e) {
                e.printStackTrace();
            }
        }
        return params;
    }

    public com.pangubpm.common.utils.Result doDbSynch(String id) {
        String tableName;
        FormBusinessEntity formBusinessEntity = this.formBusinessDao.selectByTableId(id);
        if (formBusinessEntity == null) {
            return com.pangubpm.common.utils.Result.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        String tableId = formBusinessEntity.getId();
        List<FormBusinessModelColumnEntity> fieldList = this.formBusinessModelColumnDao.getByTableId(tableId);
        if (fieldList != null) {
            for (int i = 0; i < fieldList.size(); ++i) {
                FormBusinessModelColumnEntity formBusinessModelColumnEntity = fieldList.get(i);
                formBusinessModelColumnEntity.getJavaType();
            }
        }
        if (StringUtil.isStartWithNumber((String)(tableName = formBusinessEntity.getTableName()))) {
            return com.pangubpm.common.utils.Result.error((String)"\u8868\u540d\u4e0d\u80fd\u662f\u6570\u5b57\u5f00\u5934");
        }
        CgformConfigModel model = new CgformConfigModel();
        model.setTableName(tableName);
        model.setColumns(fieldList);
        model.setDbConfig(this.dataBaseConfig);
        formBusinessEntity.setCreatedTable(Boolean.valueOf(true));
        try {
            DbTableProcess dbTableProcess = new DbTableProcess();
            boolean isExist = dbTableProcess.getDbTableHandle().judgeTableIsExit(tableName);
            if (!isExist) {
                ArrayList<FormBusinessModelColumnEntity> all = new ArrayList<FormBusinessModelColumnEntity>(fieldList.size());
                for (FormBusinessModelColumnEntity p : fieldList) {
                    all.add(p);
                }
                List delColumns = fieldList.stream().filter(column -> column.getJavaType().equals("double") || column.getJavaType().equals("bigint") || column.getJavaType().equals("tinyint") || column.getJavaType().equals("json")).collect(Collectors.toList());
                fieldList.removeAll(delColumns);
                model.setColumns(fieldList);
                DbTableProcess.createTable((CgformConfigModel)model);
                if (delColumns != null && delColumns.size() > 0) {
                    model.setColumns(all);
                    List list = dbTableProcess.updateTable(model);
                    for (String sql : list) {
                        if (oConvertUtils.isEmpty((Object)sql) || oConvertUtils.isEmpty((Object)sql.trim()) || sql.contains("id_") || sql.contains("status_") || sql.contains("business_key_")) continue;
                        ((FormBusinessDao)this.baseMapper).executeDDL(sql);
                    }
                }
            } else {
                List list = dbTableProcess.updateTable(model);
                for (String sql : list) {
                    if (oConvertUtils.isEmpty((Object)sql) || oConvertUtils.isEmpty((Object)sql.trim()) || sql.contains("id_") || sql.contains("status_") || sql.contains("business_key_")) continue;
                    ((FormBusinessDao)this.baseMapper).executeDDL(sql);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        catch (DBException e) {
            e.printStackTrace();
        }
        return com.pangubpm.common.utils.Result.ok();
    }
}

