/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.pangubpm.common.utils.Query;
import com.pangubpm.common.utils.Result;
import com.pangubpm.common.utils.httpclient.HttpConnectionManager;
import com.pangubpm.common.utils.httpclient.ResponseDTO;
import com.pangubpm.modules.form.dao.FormCustomQueryDao;
import com.pangubpm.modules.form.entity.FormCustomQuery;
import com.pangubpm.modules.form.entity.FormCustomQueryWithBLOBs;
import com.pangubpm.modules.form.service.FormCustomQueryService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="formCustomQueryService")
public class FormCustomQueryServiceImpl
implements FormCustomQueryService {
    @Value(value="${pangu.customerQueryUrl:}")
    private String customerQueryUrl;
    @Autowired
    private FormCustomQueryDao formCustomQueryDao;

    public Result queryPage(Map<String, Object> params) {
        IPage page = new Query().getPage(params);
        IPage lists = this.formCustomQueryDao.queryPage(page, params);
        List records = lists.getRecords();
        return Result.ok().put("count", (Object)lists.getTotal()).put("data", (Object)records);
    }

    public void saveAndCeateJson(String userId, FormCustomQueryWithBLOBs formCustomQueryWithBLOBs) {
        this.formCustomQueryDao.save(formCustomQueryWithBLOBs);
    }

    public void removeByIds(List<String> list) {
        this.formCustomQueryDao.removeByIds(list);
    }

    public Result getById(String id) {
        FormCustomQuery formCustomQuery = this.formCustomQueryDao.getById(id);
        return Result.ok().put("data", (Object)formCustomQuery);
    }

    public void updateById(FormCustomQueryWithBLOBs formCustomQueryWithBLOBs) {
        this.formCustomQueryDao.updateById(formCustomQueryWithBLOBs);
    }

    public Result customerQueryByKey(String key) {
        FormCustomQuery formCustomQuery = this.formCustomQueryDao.getByKey(key);
        String url = formCustomQuery.getUrl();
        String requestType = formCustomQuery.getRequestType();
        String preUrl = this.customerQueryUrl + url;
        ResponseDTO responseDTO = new ResponseDTO();
        switch (requestType) {
            case "GET": {
                responseDTO = HttpConnectionManager.doGet((String)preUrl);
                break;
            }
            case "POST": {
                responseDTO = HttpConnectionManager.doPost((String)preUrl);
                break;
            }
        }
        JSONArray jsonArray = null;
        int code = responseDTO.getCode();
        if (code == 200) {
            Object attach = responseDTO.getAttach();
            JSONObject jsonObject = JSON.parseObject((String)((String)attach));
            jsonArray = jsonObject.getJSONArray(formCustomQuery.getListKey());
        }
        return Result.ok().put("data", jsonArray);
    }

    public Result getByKey(String key) {
        FormCustomQuery formCustomQuery = this.formCustomQueryDao.getByKey(key);
        return Result.ok().put("data", (Object)formCustomQuery);
    }
}

