/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.moldudp64;

import com.paritytrading.foundation.ByteBuffers;
import com.paritytrading.nassau.Clock;
import com.paritytrading.nassau.moldudp64.MoldUDP64;
import com.paritytrading.nassau.moldudp64.MoldUDP64DownstreamPacket;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public class MoldUDP64Server
implements Closeable {
    private static final long HEARTBEAT_INTERVAL_MILLIS = 1000L;
    private final Clock clock;
    private final DatagramChannel channel;
    private final ByteBuffer[] txBuffers;
    private final byte[] session;
    private long nextSequenceNumber;
    private long lastHeartbeatMillis;

    public MoldUDP64Server(DatagramChannel channel, String session) {
        this(System::currentTimeMillis, channel, session);
    }

    public MoldUDP64Server(Clock clock, DatagramChannel channel, String session) {
        this(clock, channel, MoldUDP64.session(session));
    }

    private MoldUDP64Server(Clock clock, DatagramChannel channel, byte[] session) {
        this.clock = clock;
        this.channel = channel;
        this.txBuffers = new ByteBuffer[2];
        this.session = session;
        this.nextSequenceNumber = 1L;
        this.lastHeartbeatMillis = clock.currentTimeMillis();
        this.txBuffers[0] = ByteBuffer.allocateDirect(20);
    }

    public DatagramChannel getChannel() {
        return this.channel;
    }

    public void send(MoldUDP64DownstreamPacket packet) throws IOException {
        this.txBuffers[0].clear();
        this.txBuffers[0].put(this.session);
        this.txBuffers[0].putLong(this.nextSequenceNumber);
        ByteBuffers.putUnsignedShort((ByteBuffer)this.txBuffers[0], (int)packet.messageCount());
        this.txBuffers[0].flip();
        this.txBuffers[1] = packet.payload();
        this.txBuffers[1].flip();
        while (this.channel.write(this.txBuffers) == 0L) {
        }
        this.nextSequenceNumber += (long)packet.messageCount();
    }

    public void sendHeartbeat() throws IOException {
        this.send(0);
    }

    public void sendEndOfSession() throws IOException {
        this.send(65535);
    }

    private void send(int messageCount) throws IOException {
        this.txBuffers[0].clear();
        this.txBuffers[0].put(this.session);
        this.txBuffers[0].putLong(this.nextSequenceNumber);
        ByteBuffers.putUnsignedShort((ByteBuffer)this.txBuffers[0], (int)messageCount);
        this.txBuffers[0].flip();
        while (this.channel.write(this.txBuffers[0]) == 0) {
        }
    }

    public void keepAlive() throws IOException {
        long currentTimeMillis = this.clock.currentTimeMillis();
        if (currentTimeMillis - this.lastHeartbeatMillis >= 1000L) {
            this.sendHeartbeat();
            this.lastHeartbeatMillis = currentTimeMillis;
        }
    }

    public void setNextSequenceNumber(int nextSequenceNumber) {
        this.nextSequenceNumber = nextSequenceNumber;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

