/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Authorization;
import com.paypal.api.payments.Capture;
import com.paypal.api.payments.FmfDetails;
import com.paypal.api.payments.Links;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.util.HashMap;
import java.util.List;

public class Order
extends PayPalResource {
    private String id;
    private String purchaseUnitReferenceId;
    private Amount amount;
    private String paymentMode;
    private String state;
    private String reasonCode;
    private String pendingReason;
    private String protectionEligibility;
    private String protectionEligibilityType;
    private String parentPayment;
    private FmfDetails fmfDetails;
    private String createTime;
    private String updateTime;
    private List<Links> links;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public Order() {
    }

    public Order(Amount amount) {
        this.amount = amount;
    }

    public Order setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Order setPurchaseUnitReferenceId(String purchaseUnitReferenceId) {
        this.purchaseUnitReferenceId = purchaseUnitReferenceId;
        return this;
    }

    public String getPurchaseUnitReferenceId() {
        return this.purchaseUnitReferenceId;
    }

    public Order setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Order setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
        return this;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public Order setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public Order setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public Order setPendingReason(String pendingReason) {
        this.pendingReason = pendingReason;
        return this;
    }

    public String getPendingReason() {
        return this.pendingReason;
    }

    public Order setProtectionEligibility(String protectionEligibility) {
        this.protectionEligibility = protectionEligibility;
        return this;
    }

    public String getProtectionEligibility() {
        return this.protectionEligibility;
    }

    public Order setProtectionEligibilityType(String protectionEligibilityType) {
        this.protectionEligibilityType = protectionEligibilityType;
        return this;
    }

    public String getProtectionEligibilityType() {
        return this.protectionEligibilityType;
    }

    public Order setParentPayment(String parentPayment) {
        this.parentPayment = parentPayment;
        return this;
    }

    public String getParentPayment() {
        return this.parentPayment;
    }

    public Order setFmfDetails(FmfDetails fmfDetails) {
        this.fmfDetails = fmfDetails;
        return this;
    }

    public FmfDetails getFmfDetails() {
        return this.fmfDetails;
    }

    public Order setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Order setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Order setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public static Order get(String accessToken, String orderId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Order.get(apiContext, orderId);
    }

    public static Order get(APIContext apiContext, String orderId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (orderId == null) {
            throw new IllegalArgumentException("orderId cannot be null");
        }
        Object[] parameters = new Object[]{orderId};
        String pattern = "v1/payments/orders/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Order.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Order.class);
    }

    public Capture capture(String accessToken, Capture capture) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.capture(apiContext, capture);
    }

    public Capture capture(APIContext apiContext, Capture capture) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (capture == null) {
            throw new IllegalArgumentException("capture cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/orders/{0}/capture";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = capture.toJSON();
        return Order.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Capture.class);
    }

    public Order doVoid(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.doVoid(apiContext);
    }

    public Order doVoid(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/orders/{0}/do-void";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Order.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Order.class);
    }

    public Authorization authorize(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.authorize(apiContext);
    }

    public Authorization authorize(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/orders/{0}/authorize";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = this.toJSON();
        return Order.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Authorization.class);
    }
}

