/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.util;

import com.paypal.base.codec.binary.Base64;
import com.paypal.base.exception.OAuthException;
import com.paypal.base.util.PayPalURLEncoder;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OAuthSignature {
    private static final String PARAM_DELIMETER = "&";
    private static final String PARAM_SEPERATOR = "=";
    private static final String ENCODING = "US-ASCII";
    private static final String SIGNATURE_METHOD = "HMAC-SHA1";
    private static final String SIGNATURE_ALGORITHM = "HmacSHA1";
    public static final String OAUTH_VERSION = "1.0";
    private String consumerKey;
    private String consumerSecret;
    private String token;
    private String tokenSecret;
    private String requestURI;
    private String timestamp;
    private String httpMethod;
    private List<Parameter> queryParams = new ArrayList<Parameter>();

    public OAuthSignature(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.httpMethod = "POST";
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void addParameter(String name, String value) {
        this.queryParams.add(new Parameter(name, value));
    }

    public void setTokenSecret(String secret) {
        this.tokenSecret = secret;
    }

    public void setRequestURI(String uri) throws OAuthException {
        this.requestURI = this.normalizeURI(uri);
    }

    public void setTokenTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setHTTPMethod(HTTPMethod method) {
        switch (method) {
            case GET: {
                this.httpMethod = "GET";
                break;
            }
            case HEAD: {
                this.httpMethod = "HEAD";
                break;
            }
            case PUT: {
                this.httpMethod = "PUT";
                break;
            }
            case UPDATE: {
                this.httpMethod = "UPDATE";
                break;
            }
            default: {
                this.httpMethod = "POST";
            }
        }
    }

    public String computeV1Signature() throws OAuthException {
        this.validate(this.consumerKey, "API UserName");
        this.validate(this.consumerSecret, "API Password");
        this.validate(this.token, "Access Token");
        this.validate(this.tokenSecret, "Token Secret");
        this.validate(this.requestURI, "Request URI");
        this.validate(this.timestamp, "Timestamp");
        String signature = "";
        try {
            String key = PayPalURLEncoder.encode(this.consumerSecret, ENCODING);
            key = key + PARAM_DELIMETER;
            key = key + PayPalURLEncoder.encode(this.tokenSecret, ENCODING);
            List<Parameter> params = this.queryParams;
            params.add(new Parameter("oauth_consumer_key", this.consumerKey));
            params.add(new Parameter("oauth_version", OAUTH_VERSION));
            params.add(new Parameter("oauth_signature_method", SIGNATURE_METHOD));
            params.add(new Parameter("oauth_token", this.token));
            params.add(new Parameter("oauth_timestamp", this.timestamp));
            Collections.sort(params, new ParamComparator());
            String signatureBase = this.httpMethod + PARAM_DELIMETER;
            signatureBase = signatureBase + PayPalURLEncoder.encode(this.requestURI, ENCODING);
            signatureBase = signatureBase + PARAM_DELIMETER;
            String paramString = "";
            StringBuilder paramStringBuilder = new StringBuilder();
            Iterator<Parameter> it = params.iterator();
            while (it.hasNext()) {
                Parameter current = it.next();
                paramStringBuilder.append(current.getName()).append(PARAM_SEPERATOR).append(current.getValue());
                if (!it.hasNext()) continue;
                paramStringBuilder.append(PARAM_DELIMETER);
            }
            paramString = paramStringBuilder.toString();
            signatureBase = signatureBase + PayPalURLEncoder.encode(paramString, ENCODING);
            Mac hmac = Mac.getInstance(SIGNATURE_ALGORITHM);
            hmac.init(new SecretKeySpec(key.getBytes(ENCODING), hmac.getAlgorithm()));
            hmac.update(signatureBase.getBytes(ENCODING));
            byte[] digest = hmac.doFinal();
            Base64 b64Encoder = new Base64();
            signature = new String(b64Encoder.encode(digest), ENCODING);
        }
        catch (NoSuchAlgorithmException algoe) {
            throw new OAuthException(algoe.getMessage(), algoe);
        }
        catch (InvalidKeyException ke) {
            throw new OAuthException(ke.getMessage(), ke);
        }
        catch (UnsupportedEncodingException ee) {
            throw new OAuthException(ee.getMessage(), ee);
        }
        return signature;
    }

    private void validate(String param, String name) throws OAuthException {
        if (param == null || param.length() == 0) {
            throw new OAuthException("Value is required: " + name);
        }
    }

    public boolean verifyV1Signature(String signature) throws OAuthException {
        String signatureComputed = this.computeV1Signature();
        return signatureComputed.equals(signature);
    }

    private String normalizeURI(String uri) throws OAuthException {
        String normalizedURI = "";
        String port = "";
        String scheme = "";
        String path = "";
        String authority = "";
        try {
            int k;
            int i = uri.indexOf(58);
            if (i == -1) {
                throw new OAuthException("Invalid URI.");
            }
            scheme = uri.substring(0, i);
            int j = uri.indexOf(":", i + 2);
            if (j != -1) {
                authority = uri.substring(scheme.length() + 3, j);
                k = uri.indexOf("/", j);
                port = k != -1 ? uri.substring(j + 1, k) : uri.substring(j + 1);
            } else {
                k = uri.indexOf("/", scheme.length() + 3);
                authority = k != -1 ? uri.substring(scheme.length() + 3, k) : uri.substring(scheme.length() + 3);
            }
            if (k != -1) {
                path = uri.substring(k);
            }
            normalizedURI = scheme.toLowerCase(Locale.US);
            normalizedURI = normalizedURI + "://";
            normalizedURI = normalizedURI + authority.toLowerCase(Locale.US);
            if (scheme != null && port.length() > 0) {
                if (scheme.equalsIgnoreCase("http") && Integer.parseInt(port) != 80) {
                    normalizedURI = normalizedURI + ":";
                    normalizedURI = normalizedURI + port;
                } else if (scheme.equalsIgnoreCase("https") && Integer.parseInt(port) != 443) {
                    normalizedURI = normalizedURI + ":";
                    normalizedURI = normalizedURI + port;
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new OAuthException("Invalid URI.", nfe);
        }
        normalizedURI = normalizedURI + path;
        return normalizedURI;
    }

    public static Map getAuthHeader(String apiUserName, String apiPassword, String accessToken, String tokenSecret, HTTPMethod httpMethod, String scriptURI, Map queryParams) throws OAuthException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String consumerKey = apiUserName;
        String consumerSecretStr = apiPassword;
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        OAuthSignature oauth = new OAuthSignature(consumerKey, consumerSecretStr);
        if (HTTPMethod.GET.equals((Object)httpMethod) && queryParams != null) {
            for (Map.Entry param : queryParams.entrySet()) {
                String key = (String)param.getKey();
                String value = (String)param.getValue();
                oauth.addParameter(key, value);
            }
        }
        oauth.setToken(accessToken);
        oauth.setTokenSecret(tokenSecret);
        oauth.setHTTPMethod(httpMethod);
        oauth.setTokenTimestamp(time);
        oauth.setRequestURI(scriptURI);
        String sig = oauth.computeV1Signature();
        headers.put("Signature", sig);
        headers.put("TimeStamp", time);
        return headers;
    }

    public static String getFullAuthString(String apiUserName, String apiPassword, String accessToken, String tokenSecret, HTTPMethod httpMethod, String scriptURI, Map queryParams) throws OAuthException {
        Map headers = OAuthSignature.getAuthHeader(apiUserName, apiPassword, accessToken, tokenSecret, httpMethod, scriptURI, queryParams);
        return "token=" + accessToken + ",signature=" + headers.get("Signature") + ",timestamp=" + headers.get("TimeStamp");
    }

    private static class Parameter {
        private String mName;
        private String mValue;

        public Parameter(String name, String value) {
            this.mName = name;
            this.mValue = value;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public void setValue(String val) {
            this.mValue = val;
        }

        public String getName() {
            return this.mName;
        }

        public String getValue() {
            return this.mValue;
        }
    }

    private static class ParamComparator
    implements Comparator<Parameter>,
    Serializable {
        private static final long serialVersionUID = 8587372068875833370L;

        private ParamComparator() {
        }

        @Override
        public int compare(Parameter x, Parameter y) {
            int retval = 0;
            if (x != null && y != null && (retval = x.getName().compareTo(y.getName())) == 0) {
                retval = x.getValue().compareTo(y.getValue());
            }
            return retval;
        }
    }

    public static enum HTTPMethod {
        GET,
        HEAD,
        POST,
        PUT,
        UPDATE;

    }
}

