/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.listener;

import com.alibaba.nacos.core.utils.SystemUtils;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.ConfigurableEnvironment;

public class StandaloneProfileApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
PriorityOrdered {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneProfileApplicationListener.class);

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        if (((Boolean)environment.getProperty("nacos.standalone", Boolean.TYPE, (Object)false)).booleanValue()) {
            environment.addActiveProfile("standalone");
        }
        if (logger.isInfoEnabled()) {
            logger.info("Spring Environment's active profiles : {} in standalone mode : {}", Arrays.asList(environment.getActiveProfiles()), (Object)SystemUtils.STANDALONE_MODE);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

