/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import com.alibaba.nacos.core.utils.PropertyUtil;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetUtils {
    private static final Logger log;
    private static String selfIp;
    private static boolean useOnlySiteLocalInterface;
    private static boolean preferHostnameOverIp;
    private static List<String> preferredNetworks;
    private static List<String> ignoredInterfaces;

    public static String getSelfIp() {
        return selfIp;
    }

    public static InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                log.info("Testing interface: " + ifc.getDisplayName());
                if (ifc.getIndex() < lowest || result == null) {
                    lowest = ifc.getIndex();
                } else if (result != null) continue;
                if (InetUtils.ignoreInterface(ifc.getDisplayName())) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress() || !InetUtils.isPreferredAddress(address)) continue;
                    log.info("Found non-loopback interface: " + ifc.getDisplayName());
                    result = address;
                }
            }
        }
        catch (IOException ex) {
            log.error("Cannot get first non-loopback address", (Throwable)ex);
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.warn("Unable to retrieve localhost");
            return null;
        }
    }

    public static boolean isPreferredAddress(InetAddress address) {
        if (useOnlySiteLocalInterface) {
            boolean siteLocalAddress = address.isSiteLocalAddress();
            if (!siteLocalAddress) {
                log.info("Ignoring address: " + address.getHostAddress());
            }
            return siteLocalAddress;
        }
        if (preferredNetworks.isEmpty()) {
            return true;
        }
        for (String regex : preferredNetworks) {
            String hostAddress = address.getHostAddress();
            if (!hostAddress.matches(regex) && !hostAddress.startsWith(regex)) continue;
            return true;
        }
        return false;
    }

    public static boolean ignoreInterface(String interfaceName) {
        for (String regex : ignoredInterfaces) {
            if (!interfaceName.matches(regex)) continue;
            log.info("Ignoring interface: " + interfaceName);
            return true;
        }
        return false;
    }

    public static boolean isIP(String str) {
        String num = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
        String regex = "^" + num + "\\." + num + "\\." + num + "\\." + num + "$";
        return InetUtils.match(regex, str);
    }

    public static boolean match(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_6;
        log = LoggerFactory.getLogger(InetUtils.class);
        useOnlySiteLocalInterface = false;
        preferHostnameOverIp = false;
        preferredNetworks = new ArrayList<String>();
        ignoredInterfaces = new ArrayList<String>();
        useOnlySiteLocalInterface = Boolean.valueOf(PropertyUtil.getProperty("nacos.inetutils.use-only-site-local-interfaces"));
        List<String> networks = PropertyUtil.getPropertyList("nacos.inetutils.preferred-networks");
        for (String string : networks) {
            preferredNetworks.add(string);
        }
        List<String> interfaces = PropertyUtil.getPropertyList("nacos.inetutils.ignored-interfaces");
        for (String ignored : interfaces) {
            ignoredInterfaces.add(ignored);
        }
        String string = System.getProperty("nacos.server.ip");
        if (StringUtils.isBlank((CharSequence)string)) {
            String string2 = PropertyUtil.getProperty("nacos.inetutils.ip-address");
        }
        if (!StringUtils.isBlank((CharSequence)var2_6) && !InetUtils.isIP((String)var2_6)) {
            throw new RuntimeException("nacos address " + (String)var2_6 + " is not ip");
        }
        selfIp = var2_6;
        if (StringUtils.isBlank((CharSequence)selfIp)) {
            preferHostnameOverIp = Boolean.getBoolean("nacos.preferHostnameOverIp");
            if (!preferHostnameOverIp) {
                preferHostnameOverIp = Boolean.parseBoolean(PropertyUtil.getProperty("nacos.inetutils.prefer-hostname-over-ip"));
            }
            if (preferHostnameOverIp) {
                InetAddress inetAddress = null;
                try {
                    inetAddress = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                selfIp = inetAddress.getHostName().equals(inetAddress.getCanonicalHostName()) ? inetAddress.getHostName() : inetAddress.getCanonicalHostName();
            } else {
                selfIp = InetUtils.findFirstNonLoopbackAddress().getHostAddress();
            }
        }
    }
}

