/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static Properties properties = new Properties();
    private static final Logger log = LoggerFactory.getLogger(PropertyUtil.class);

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static List<String> getPropertyList(String key) {
        String value;
        ArrayList<String> valueList = new ArrayList<String>();
        for (int i = 0; i < Integer.MAX_VALUE && !StringUtils.isBlank((CharSequence)(value = properties.getProperty(key + "[" + i + "]"))); ++i) {
            valueList.add(value);
        }
        return valueList;
    }

    static {
        InputStream inputStream = null;
        try {
            String baseDir = System.getProperty("nacos.home");
            inputStream = !StringUtils.isBlank((CharSequence)baseDir) ? new FileInputStream(baseDir + "/conf/application.properties") : PropertyUtil.class.getResourceAsStream("/application.properties");
            properties.load(inputStream);
        }
        catch (Exception e) {
            try {
                log.error("read property file error:" + e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }
}

