/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import com.alibaba.nacos.common.util.IoUtils;
import com.alibaba.nacos.core.utils.InetUtils;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SystemUtils {
    public static final boolean STANDALONE_MODE = Boolean.getBoolean("nacos.standalone");
    public static final String STANDALONE_MODE_ALONE = "standalone";
    public static final String STANDALONE_MODE_CLUSTER = "cluster";
    public static final String FUNCTION_MODE = System.getProperty("nacos.functionMode");
    public static final String FUNCTION_MODE_CONFIG = "config";
    public static final String FUNCTION_MODE_NAMING = "naming";
    private static OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    public static final String LOCAL_IP = InetUtils.getSelfIp();
    public static final String NACOS_HOME_KEY = "nacos.home";
    public static final String NACOS_HOME = SystemUtils.getNacosHome();
    public static final String CLUSTER_CONF_FILE_PATH = SystemUtils.getClusterConfFilePath();

    public static List<String> getIPsBySystemEnv(String key) {
        String env = SystemUtils.getSystemEnv(key);
        List<String> ips = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)env)) {
            ips = Arrays.asList(env.split(","));
        }
        return ips;
    }

    public static String getSystemEnv(String key) {
        return System.getenv(key);
    }

    public static float getLoad() {
        return (float)operatingSystemMXBean.getSystemLoadAverage();
    }

    public static float getCPU() {
        return (float)operatingSystemMXBean.getSystemCpuLoad();
    }

    public static float getMem() {
        return (float)(1.0 - (double)operatingSystemMXBean.getFreePhysicalMemorySize() / (double)operatingSystemMXBean.getTotalPhysicalMemorySize());
    }

    private static String getNacosHome() {
        String nacosHome = System.getProperty(NACOS_HOME_KEY);
        if (StringUtils.isBlank((CharSequence)nacosHome)) {
            nacosHome = System.getProperty("user.home") + File.separator + "nacos";
        }
        return nacosHome;
    }

    public static String getConfFilePath() {
        return NACOS_HOME + File.separator + "conf" + File.separator;
    }

    private static String getClusterConfFilePath() {
        return NACOS_HOME + File.separator + "conf" + File.separator + "cluster.conf";
    }

    public static List<String> readClusterConf() throws IOException {
        ArrayList<String> instanceList = new ArrayList<String>();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(CLUSTER_CONF_FILE_PATH)), StandardCharsets.UTF_8);){
            List lines = IoUtils.readLines((Reader)reader);
            String comment = "#";
            for (String line : lines) {
                int multiIndex;
                String instance = line.trim();
                if (instance.startsWith(comment)) continue;
                if (instance.contains(comment)) {
                    instance = instance.substring(0, instance.indexOf(comment));
                    instance = instance.trim();
                }
                if ((multiIndex = instance.indexOf(",")) > 0) {
                    instanceList.addAll(Arrays.asList(instance.split(",")));
                    continue;
                }
                instanceList.add(instance);
            }
            ArrayList<String> arrayList = instanceList;
            return arrayList;
        }
    }

    public static void writeClusterConf(String content) throws IOException {
        IoUtils.writeStringToFile((File)new File(CLUSTER_CONF_FILE_PATH), (String)content, (String)"UTF-8");
    }
}

