/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class WebUtils {
    public static String required(HttpServletRequest req, String key) {
        String value = req.getParameter(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException("Param '" + key + "' is required.");
        }
        String encoding = req.getParameter("encoding");
        if (!StringUtils.isEmpty((CharSequence)encoding)) {
            try {
                value = new String(value.getBytes(StandardCharsets.UTF_8), encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value.trim();
    }

    public static String optional(HttpServletRequest req, String key, String defaultValue) {
        if (!req.getParameterMap().containsKey(key) || ((String[])req.getParameterMap().get(key))[0] == null) {
            return defaultValue;
        }
        String value = req.getParameter(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        String encoding = req.getParameter("encoding");
        if (!StringUtils.isEmpty((CharSequence)encoding)) {
            try {
                value = new String(value.getBytes(StandardCharsets.UTF_8), encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value.trim();
    }

    public static String getAcceptEncoding(HttpServletRequest req) {
        String encode = (String)StringUtils.defaultIfEmpty((CharSequence)req.getHeader("Accept-Charset"), (CharSequence)"UTF-8");
        encode = encode.contains(",") ? encode.substring(0, encode.indexOf(",")) : encode;
        return encode.contains(";") ? encode.substring(0, encode.indexOf(";")) : encode;
    }

    public static String getUserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.isEmpty((CharSequence)userAgent)) {
            userAgent = (String)StringUtils.defaultIfEmpty((CharSequence)request.getHeader("Client-Version"), (CharSequence)"");
        }
        return userAgent;
    }
}

