/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.raft;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.MapUtil;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.consistency.ProtocolMetaData;
import com.alibaba.nacos.consistency.SerializeFactory;
import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.cp.CPProtocol;
import com.alibaba.nacos.consistency.cp.RequestProcessor4CP;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.distributed.AbstractConsistencyProtocol;
import com.alibaba.nacos.core.distributed.raft.JRaftMaintainService;
import com.alibaba.nacos.core.distributed.raft.JRaftServer;
import com.alibaba.nacos.core.distributed.raft.RaftConfig;
import com.alibaba.nacos.core.distributed.raft.RaftEvent;
import com.alibaba.nacos.core.distributed.raft.exception.NoSuchRaftGroupException;
import com.alibaba.nacos.core.utils.Loggers;
import com.alipay.sofa.jraft.Node;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class JRaftProtocol
extends AbstractConsistencyProtocol<RaftConfig, RequestProcessor4CP>
implements CPProtocol<RaftConfig, RequestProcessor4CP> {
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean shutdowned = new AtomicBoolean(false);
    private final Serializer serializer = SerializeFactory.getDefault();
    private RaftConfig raftConfig;
    private JRaftServer raftServer;
    private JRaftMaintainService jRaftMaintainService;
    private ServerMemberManager memberManager;

    public JRaftProtocol(ServerMemberManager memberManager) throws Exception {
        this.memberManager = memberManager;
        this.raftServer = new JRaftServer();
        this.jRaftMaintainService = new JRaftMaintainService(this.raftServer);
    }

    public void init(RaftConfig config) {
        if (this.initialized.compareAndSet(false, true)) {
            this.raftConfig = config;
            NotifyCenter.registerToSharePublisher(RaftEvent.class);
            this.raftServer.init(this.raftConfig);
            this.raftServer.start();
            NotifyCenter.registerSubscriber((Subscriber)new Subscriber<RaftEvent>(){

                public void onEvent(RaftEvent event) {
                    Loggers.RAFT.info("This Raft event changes : {}", (Object)event);
                    String groupId = event.getGroupId();
                    HashMap value = new HashMap();
                    HashMap properties = new HashMap();
                    String leader = event.getLeader();
                    Long term = event.getTerm();
                    List<String> raftClusterInfo = event.getRaftClusterInfo();
                    String errMsg = event.getErrMsg();
                    MapUtil.putIfValNoEmpty(properties, (Object)"leader", (Object)leader);
                    MapUtil.putIfValNoNull(properties, (Object)"term", (Object)term);
                    MapUtil.putIfValNoEmpty(properties, (Object)"raftGroupMember", raftClusterInfo);
                    MapUtil.putIfValNoEmpty(properties, (Object)"errMsg", (Object)errMsg);
                    value.put(groupId, properties);
                    JRaftProtocol.this.metaData.load(value);
                    JRaftProtocol.this.injectProtocolMetaData(JRaftProtocol.this.metaData);
                }

                public Class<? extends Event> subscribeType() {
                    return RaftEvent.class;
                }
            });
        }
    }

    public void addRequestProcessors(Collection<RequestProcessor4CP> processors) {
    }

    public Response getData(ReadRequest request) throws Exception {
        CompletableFuture<Response> future = this.aGetData(request);
        return future.get(5000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<Response> aGetData(ReadRequest request) {
        return this.raftServer.get(request);
    }

    public Response write(WriteRequest request) throws Exception {
        CompletableFuture<Response> future = this.writeAsync(request);
        return future.get(10000L, TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<Response> writeAsync(WriteRequest request) {
        return this.raftServer.commit(request.getGroup(), (Message)request, new CompletableFuture<Response>());
    }

    public void memberChange(Set<String> addresses) {
        for (int i = 0; i < 5; ++i) {
            if (this.raftServer.peerChange(this.jRaftMaintainService, addresses)) {
                return;
            }
            ThreadUtils.sleep((long)100L);
        }
        Loggers.RAFT.warn("peer removal failed");
    }

    public void shutdown() {
        if (this.initialized.get() && this.shutdowned.compareAndSet(false, true)) {
            Loggers.RAFT.info("shutdown jraft server");
            this.raftServer.shutdown();
        }
    }

    public RestResult<String> execute(Map<String, String> args) {
        return this.jRaftMaintainService.execute(args);
    }

    private void injectProtocolMetaData(ProtocolMetaData metaData) {
        Member member = this.memberManager.getSelf();
        member.setExtendVal("raftMetaData", metaData);
        this.memberManager.update(member);
    }

    public boolean isLeader(String group) {
        Node node = this.raftServer.findNodeByGroup(group);
        if (node == null) {
            throw new NoSuchRaftGroupException(group);
        }
        return node.isLeader();
    }
}

