/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.raft.processor;

import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.core.distributed.raft.JRaftServer;
import com.alibaba.nacos.core.distributed.raft.utils.FailoverClosure;
import com.alibaba.nacos.core.utils.Loggers;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.rpc.RpcContext;
import com.google.protobuf.Message;
import java.util.Objects;

public abstract class AbstractProcessor {
    private final Serializer serializer;

    public AbstractProcessor(Serializer serializer) {
        this.serializer = serializer;
    }

    protected void handleRequest(JRaftServer server, String group, RpcContext rpcCtx, Message message) {
        try {
            JRaftServer.RaftGroupTuple tuple = server.findTupleByGroup(group);
            if (Objects.isNull(tuple)) {
                rpcCtx.sendResponse((Object)Response.newBuilder().setSuccess(false).setErrMsg("Could not find the corresponding Raft Group : " + group).build());
                return;
            }
            if (tuple.getNode().isLeader()) {
                this.execute(server, rpcCtx, message, tuple);
            } else {
                rpcCtx.sendResponse((Object)Response.newBuilder().setSuccess(false).setErrMsg("Could not find leader : " + group).build());
            }
        }
        catch (Throwable e) {
            Loggers.RAFT.error("handleRequest has error : ", e);
            rpcCtx.sendResponse((Object)Response.newBuilder().setSuccess(false).setErrMsg(e.toString()).build());
        }
    }

    protected void execute(JRaftServer server, final RpcContext asyncCtx, Message message, JRaftServer.RaftGroupTuple tuple) {
        FailoverClosure closure = new FailoverClosure(){
            Response data;
            Throwable ex;

            @Override
            public void setResponse(Response data) {
                this.data = data;
            }

            @Override
            public void setThrowable(Throwable throwable) {
                this.ex = throwable;
            }

            public void run(Status status) {
                if (Objects.nonNull(this.ex)) {
                    Loggers.RAFT.error("execute has error : ", this.ex);
                    asyncCtx.sendResponse((Object)Response.newBuilder().setErrMsg(this.ex.toString()).setSuccess(false).build());
                } else {
                    asyncCtx.sendResponse((Object)this.data);
                }
            }
        };
        server.applyOperation(tuple.getNode(), message, closure);
    }
}

