/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.raft.utils;

import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.exception.ConsistencyException;
import com.alibaba.nacos.core.distributed.raft.utils.FailoverClosure;
import com.alipay.sofa.jraft.Status;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class FailoverClosureImpl
implements FailoverClosure {
    private final CompletableFuture<Response> future;
    private volatile Response data;
    private volatile Throwable throwable;

    public FailoverClosureImpl(CompletableFuture<Response> future) {
        this.future = future;
    }

    @Override
    public void setResponse(Response data) {
        this.data = data;
    }

    @Override
    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public void run(Status status) {
        if (status.isOk()) {
            this.future.complete(this.data);
            return;
        }
        Throwable throwable = this.throwable;
        this.future.completeExceptionally((Throwable)(Objects.nonNull(throwable) ? new ConsistencyException(throwable.toString()) : new ConsistencyException("operation failure")));
    }
}

