/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.DefaultRequestFuture;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.core.utils.Loggers;
import com.alipay.hessian.clhm.ConcurrentLinkedHashMap;
import com.alipay.hessian.clhm.EvictionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class RpcAckCallbackSynchronizer {
    public static final Map<String, Map<String, DefaultRequestFuture>> CALLBACK_CONTEXT = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(1000000).listener((EvictionListener)new EvictionListener<String, Map<String, DefaultRequestFuture>>(){

        public void onEviction(String s, Map<String, DefaultRequestFuture> pushCallBack) {
            pushCallBack.entrySet().forEach(new Consumer<Map.Entry<String, DefaultRequestFuture>>(){

                @Override
                public void accept(Map.Entry<String, DefaultRequestFuture> stringDefaultPushFutureEntry) {
                    stringDefaultPushFutureEntry.getValue().setFailResult((Exception)new TimeoutException());
                }
            });
        }
    }).build();

    public static void ackNotify(String connectionId, Response response) {
        Map<String, DefaultRequestFuture> stringDefaultPushFutureMap = CALLBACK_CONTEXT.get(connectionId);
        if (stringDefaultPushFutureMap == null) {
            Loggers.REMOTE_DIGEST.warn("Ack receive on a outdated connection ,connection id={},requestId={} ", (Object)connectionId, (Object)response.getRequestId());
            return;
        }
        DefaultRequestFuture currentCallback = stringDefaultPushFutureMap.remove(response.getRequestId());
        if (currentCallback == null) {
            Loggers.REMOTE_DIGEST.warn("Ack receive on a outdated request ,connection id={},requestId={} ", (Object)connectionId, (Object)response.getRequestId());
            return;
        }
        if (response.isSuccess()) {
            currentCallback.setResponse(response);
        } else {
            currentCallback.setFailResult((Exception)((Object)new NacosException(response.getErrorCode(), response.getMessage())));
        }
    }

    public static void syncCallback(String connectionId, String requestId, DefaultRequestFuture defaultPushFuture) throws NacosException {
        DefaultRequestFuture pushCallBackPrev;
        Map<String, DefaultRequestFuture> stringDefaultPushFutureMap = RpcAckCallbackSynchronizer.initContextIfNecessary(connectionId);
        if (!stringDefaultPushFutureMap.containsKey(requestId) && (pushCallBackPrev = stringDefaultPushFutureMap.putIfAbsent(requestId, defaultPushFuture)) == null) {
            return;
        }
        throw new NacosException(400, "request id confilict");
    }

    public static void clearContext(String connectionId) {
        CALLBACK_CONTEXT.remove(connectionId);
    }

    public static Map<String, DefaultRequestFuture> initContextIfNecessary(String connectionId) {
        if (!CALLBACK_CONTEXT.containsKey(connectionId)) {
            HashMap context = new HashMap(128);
            Map stringDefaultRequestFutureMap = CALLBACK_CONTEXT.putIfAbsent(connectionId, context);
            return stringDefaultRequestFutureMap == null ? context : stringDefaultRequestFutureMap;
        }
        return CALLBACK_CONTEXT.get(connectionId);
    }

    public static void clearFuture(String connectionId, String requestId) {
        Map<String, DefaultRequestFuture> stringDefaultPushFutureMap = CALLBACK_CONTEXT.get(connectionId);
        if (stringDefaultPushFutureMap == null || !stringDefaultPushFutureMap.containsKey(requestId)) {
            return;
        }
        stringDefaultPushFutureMap.remove(requestId);
    }
}

