/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.mcp;

import com.alibaba.nacos.istio.misc.Loggers;
import io.grpc.stub.StreamObserver;
import istio.mcp.v1alpha1.Mcp;
import istio.mcp.v1alpha1.ResourceOuterClass;
import istio.mcp.v1alpha1.ResourceSourceGrpc;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class NacosMcpService
extends ResourceSourceGrpc.ResourceSourceImplBase {
    private final AtomicInteger connectIdGenerator = new AtomicInteger(0);
    private final Map<Integer, StreamObserver<Mcp.Resources>> connnections = new ConcurrentHashMap<Integer, StreamObserver<Mcp.Resources>>(16);
    private Map<String, ResourceOuterClass.Resource> resourceMapCache;

    public void sendResources(Map<String, ResourceOuterClass.Resource> resourceMap) {
        this.resourceMapCache = resourceMap;
        Loggers.MAIN.info("send resources for mcp,count : {}", (Object)resourceMap.size());
        Mcp.Resources resources = this.generateResponse(resourceMap);
        if (Loggers.MAIN.isDebugEnabled()) {
            Loggers.MAIN.debug("mcp resources:{}", (Object)resources.toString());
        }
        for (StreamObserver<Mcp.Resources> observer : this.connnections.values()) {
            Loggers.MAIN.info("mcp send to:{}", (Object)observer.toString());
            observer.onNext((Object)resources);
        }
    }

    private Mcp.Resources generateResponse(Map<String, ResourceOuterClass.Resource> resourceMap) {
        return Mcp.Resources.newBuilder().addAllResources(resourceMap.values()).setCollection("istio/networking/v1alpha3/serviceentries").setNonce(String.valueOf(System.currentTimeMillis())).build();
    }

    @Override
    public StreamObserver<Mcp.RequestResources> establishResourceStream(final StreamObserver<Mcp.Resources> responseObserver) {
        final int id = this.connectIdGenerator.incrementAndGet();
        this.connnections.put(id, responseObserver);
        return new StreamObserver<Mcp.RequestResources>(){
            private final int connectionId;
            {
                this.connectionId = id;
            }

            public void onNext(Mcp.RequestResources value) {
                Loggers.MAIN.info("receiving request, sink: {}, type: {}", (Object)value.getSinkNode(), (Object)value.getCollection());
                if (value.getErrorDetail() != null && value.getErrorDetail().getCode() != 0) {
                    Loggers.MAIN.error("NACK error code: {}, message: {}", (Object)value.getErrorDetail().getCode(), (Object)value.getErrorDetail().getMessage());
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)value.getResponseNonce())) {
                    Loggers.MAIN.info("ACK nonce: {}, type: {}", (Object)value.getResponseNonce(), (Object)value.getCollection());
                    return;
                }
                if (!"istio/networking/v1alpha3/serviceentries".equals(value.getCollection())) {
                    Mcp.Resources resources = Mcp.Resources.newBuilder().setCollection(value.getCollection()).setNonce(String.valueOf(System.currentTimeMillis())).build();
                    responseObserver.onNext((Object)resources);
                    return;
                }
                Mcp.Resources resources = NacosMcpService.this.generateResponse(NacosMcpService.this.resourceMapCache);
                responseObserver.onNext((Object)resources);
            }

            public void onError(Throwable t) {
                Loggers.MAIN.error("stream error.", t);
                NacosMcpService.this.connnections.remove(this.connectionId);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }
}

