/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.mcp;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.istio.mcp.NacosMcpOverXdsService;
import com.alibaba.nacos.istio.mcp.NacosMcpService;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataManager;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.google.protobuf.Any;
import com.google.protobuf.Timestamp;
import istio.mcp.v1alpha1.MetadataOuterClass;
import istio.mcp.v1alpha1.ResourceOuterClass;
import istio.networking.v1alpha3.GatewayOuterClass;
import istio.networking.v1alpha3.ServiceEntryOuterClass;
import istio.networking.v1alpha3.WorkloadEntryOuterClass;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NacosToMcpResources {
    private final Map<String, ResourceOuterClass.Resource> resourceMap = new ConcurrentHashMap<String, ResourceOuterClass.Resource>(16);
    private final Map<String, String> checksumMap = new ConcurrentHashMap<String, String>(16);
    private static final String SERVICE_NAME_SPLITTER = "nacos";
    private static final String MESSAGE_TYPE_URL = "type.googleapis.com/istio.networking.v1alpha3.ServiceEntry";
    private static final long MCP_PUSH_PERIOD_MILLISECONDS = 10000L;
    private static final String SEPARATOR = ".";
    private static final String DEFAULT_SUFFIX = ".DEFAULT-GROUP";
    private static final String PORT_PARAM = "http";
    private static final String CLUSTER_PARAM = "cluster";
    private static final String VIRTUAL_ANNOTATION = "virtual";
    private static final String DEFAULT_VIRTUAL = "1";
    private static final String HTTP = "HTTP";
    @Autowired
    private NacosMcpOverXdsService nacosMcpOverXdsService;
    @Autowired
    private NacosMcpService nacosMcpService;
    @Autowired
    private ServiceStorage serviceStorage;
    @Autowired
    private NamingMetadataManager namingMetadataManager;

    public void start() {
        GlobalExecutor.scheduleMcpPushTask((Runnable)new McpPushTask(), (long)20000L, (long)10000L);
    }

    private String convertName(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        if (!"DEFAULT_GROUP".equals(service.getGroup())) {
            return service.getName() + SEPARATOR + service.getGroup() + SEPARATOR + service.getNamespace();
        }
        return service.getName() + DEFAULT_SUFFIX + SEPARATOR + service.getNamespace();
    }

    private ResourceOuterClass.Resource convertService(com.alibaba.nacos.naming.core.v2.pojo.Service service) {
        String serviceName = this.convertName(service);
        ServiceEntryOuterClass.ServiceEntry.Builder serviceEntryBuilder = ServiceEntryOuterClass.ServiceEntry.newBuilder().setResolution(ServiceEntryOuterClass.ServiceEntry.Resolution.STATIC).setLocation(ServiceEntryOuterClass.ServiceEntry.Location.MESH_INTERNAL).addHosts(serviceName + SEPARATOR + SERVICE_NAME_SPLITTER);
        ServiceInfo serviceInfo = this.serviceStorage.getData(service);
        List hosts = serviceInfo.getHosts();
        int port = 0;
        for (Instance instance : hosts) {
            if (port == 0) {
                port = instance.getPort();
            }
            if (!instance.isHealthy() || !instance.isEnabled()) continue;
            Map metadata = instance.getMetadata();
            if (StringUtils.isNotEmpty((String)instance.getClusterName())) {
                metadata.put(CLUSTER_PARAM, instance.getClusterName());
            }
            WorkloadEntryOuterClass.WorkloadEntry workloadEntry = WorkloadEntryOuterClass.WorkloadEntry.newBuilder().setAddress(instance.getIp()).setWeight((int)instance.getWeight()).putAllLabels(metadata).putPorts(PORT_PARAM, instance.getPort()).build();
            serviceEntryBuilder.addEndpoints(workloadEntry);
        }
        serviceEntryBuilder.addPorts(GatewayOuterClass.Port.newBuilder().setNumber(port).setName(PORT_PARAM).setProtocol(HTTP).build());
        ServiceEntryOuterClass.ServiceEntry serviceEntry = serviceEntryBuilder.build();
        Optional serviceMetadata = this.namingMetadataManager.getServiceMetadata(service);
        ServiceMetadata serviceMetadataGetter = serviceMetadata.orElseGet(ServiceMetadata::new);
        Any any = Any.newBuilder().setValue(serviceEntry.toByteString()).setTypeUrl(MESSAGE_TYPE_URL).build();
        MetadataOuterClass.Metadata metadata = MetadataOuterClass.Metadata.newBuilder().setName("nacos/" + serviceName).putAllAnnotations(serviceMetadataGetter.getExtendData()).putAnnotations(VIRTUAL_ANNOTATION, DEFAULT_VIRTUAL).setCreateTime(Timestamp.newBuilder().setSeconds(System.currentTimeMillis() / 1000L).build()).setVersion(serviceInfo.getChecksum()).build();
        return ResourceOuterClass.Resource.newBuilder().setBody(any).setMetadata(metadata).build();
    }

    private class McpPushTask
    implements Runnable {
        private McpPushTask() {
        }

        @Override
        public void run() {
            ServiceManager serviceManager = ServiceManager.getInstance();
            boolean changed = false;
            Set namespaces = serviceManager.getAllNamespaces();
            HashSet<String> allServices = new HashSet<String>();
            for (String namespace : namespaces) {
                Set services = serviceManager.getSingletons(namespace);
                if (services.isEmpty()) continue;
                for (com.alibaba.nacos.naming.core.v2.pojo.Service service : services) {
                    ServiceInfo serviceInfo = NacosToMcpResources.this.serviceStorage.getData(service);
                    String convertedName = NacosToMcpResources.this.convertName(service);
                    allServices.add(convertedName);
                    if (NacosToMcpResources.this.checksumMap.containsKey(convertedName) && ((String)NacosToMcpResources.this.checksumMap.get(convertedName)).equals(serviceInfo.getChecksum())) continue;
                    changed = true;
                    if (!serviceInfo.validate()) {
                        NacosToMcpResources.this.resourceMap.remove(convertedName);
                        NacosToMcpResources.this.checksumMap.remove(convertedName);
                        continue;
                    }
                    NacosToMcpResources.this.resourceMap.put(convertedName, NacosToMcpResources.this.convertService(service));
                    NacosToMcpResources.this.checksumMap.put(convertedName, serviceInfo.getChecksum());
                }
            }
            for (String key : NacosToMcpResources.this.resourceMap.keySet()) {
                if (allServices.contains(key)) continue;
                changed = true;
                NacosToMcpResources.this.resourceMap.remove(key);
                NacosToMcpResources.this.checksumMap.remove(key);
            }
            if (!changed) {
                return;
            }
            NacosToMcpResources.this.nacosMcpOverXdsService.sendResources(NacosToMcpResources.this.resourceMap);
            NacosToMcpResources.this.nacosMcpService.sendResources(NacosToMcpResources.this.resourceMap);
        }
    }
}

