/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.core.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class GfJsonUtil {
    private GfJsonUtil() {
    }

    public static <T> T parseObject(String json, Class<T> clazz) {
        if (json == null) {
            return null;
        }
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static <T> String toJSONString(T t) {
        if (t == null) {
            return null;
        }
        return JSON.toJSONString(t);
    }

    public static <T> List<T> parseList(Iterable<String> jsonList, Class<T> clazz) {
        ArrayList<T> retList = new ArrayList<T>();
        for (String json : jsonList) {
            retList.add(GfJsonUtil.parseObject(json, clazz));
        }
        return retList;
    }

    public static <T> List<List<T>> parseArrayList(Iterable<String> jsonList, Class<T> clazz) {
        ArrayList<List<T>> retList = new ArrayList<List<T>>();
        for (String json : jsonList) {
            retList.add(GfJsonUtil.parseArray(json, clazz));
        }
        return retList;
    }

    public static <T> List<T> parseArray(String json, Class<T> clazz) {
        if (json == null) {
            return Collections.emptyList();
        }
        return JSON.parseArray((String)json, clazz);
    }

    public static <T> Map<Long, T> parseMapByUid(List<String> jsonList, List<Long> uidList, Class<T> clazz, boolean isContainsNull) {
        if (jsonList.size() != uidList.size()) {
            return null;
        }
        HashMap<Long, T> uidMap = new HashMap<Long, T>(uidList.size());
        for (int i = 0; i < uidList.size(); ++i) {
            T t = GfJsonUtil.parseObject(jsonList.get(i), clazz);
            if (!isContainsNull && t == null) continue;
            uidMap.put(uidList.get(i), t);
        }
        return uidMap;
    }

    public static <T> Map<Long, List<T>> parseArrayMapByUid(List<String> jsonList, List<Long> uidList, Class<T> clazz, boolean isContainsNull) {
        if (jsonList.size() != uidList.size()) {
            return null;
        }
        HashMap<Long, List<T>> uidMap = new HashMap<Long, List<T>>(uidList.size());
        for (int i = 0; i < uidList.size(); ++i) {
            List<T> t = GfJsonUtil.parseArray(jsonList.get(i), clazz);
            if (!isContainsNull && t == null) continue;
            uidMap.put(uidList.get(i), t);
        }
        return uidMap;
    }
}

