/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.trace.aspect;

import com.plumelog.core.LogMessageThreadLocal;
import com.plumelog.core.TraceId;
import com.plumelog.core.TraceMessage;
import com.plumelog.core.util.GfJsonUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAspect {
    private static final Logger log = LoggerFactory.getLogger(AbstractAspect.class);

    public Object aroundExecute(JoinPoint joinPoint) throws Throwable {
        TraceMessage traceMessage = (TraceMessage)LogMessageThreadLocal.logMessageThreadLocal.get();
        String traceId = (String)TraceId.logTraceID.get();
        if (traceMessage == null) {
            traceMessage = new TraceMessage();
            traceMessage.getPositionNum().set(0);
        }
        traceMessage.setMessageType(joinPoint.getSignature().toString());
        traceMessage.setPosition("<");
        traceMessage.getPositionNum().incrementAndGet();
        LogMessageThreadLocal.logMessageThreadLocal.set((Object)traceMessage);
        if (traceId != null) {
            log.info("TRACE:" + GfJsonUtil.toJSONString((Object)traceMessage));
        }
        Object proceed = ((ProceedingJoinPoint)joinPoint).proceed();
        traceMessage.setMessageType(joinPoint.getSignature().toString());
        traceMessage.setPosition(">");
        traceMessage.getPositionNum().incrementAndGet();
        if (traceId != null) {
            log.info("TRACE:" + GfJsonUtil.toJSONString((Object)traceMessage));
        }
        return proceed;
    }
}

