/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.powsybl.cgmes.extensions.BaseVoltageMapping;
import com.powsybl.cgmes.extensions.Source;
import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.iidm.network.Network;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BaseVoltageMappingImpl
extends AbstractExtension<Network>
implements BaseVoltageMapping {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseVoltageMappingImpl.class);
    private final Map<Double, BaseVoltageMapping.BaseVoltageSource> nominalVoltageBaseVoltageMap = new HashMap<Double, BaseVoltageMapping.BaseVoltageSource>();

    BaseVoltageMappingImpl(Set<BaseVoltageMapping.BaseVoltageSource> baseVoltages) {
        baseVoltages.forEach(bvs -> {
            Objects.requireNonNull(bvs);
            this.addBaseVoltage(bvs.getNominalV(), bvs.getId(), bvs.getSource());
        });
    }

    @Override
    public Map<Double, BaseVoltageMapping.BaseVoltageSource> getBaseVoltages() {
        return Collections.unmodifiableMap(this.nominalVoltageBaseVoltageMap);
    }

    @Override
    public BaseVoltageMapping.BaseVoltageSource getBaseVoltage(double nominalVoltage) {
        return this.nominalVoltageBaseVoltageMap.get(nominalVoltage);
    }

    @Override
    public boolean isBaseVoltageMapped(double nominalVoltage) {
        return this.nominalVoltageBaseVoltageMap.containsKey(nominalVoltage);
    }

    @Override
    public boolean isBaseVoltageEmpty() {
        return this.nominalVoltageBaseVoltageMap.isEmpty();
    }

    @Override
    public BaseVoltageMapping addBaseVoltage(double nominalVoltage, String baseVoltageId, Source source) {
        if (this.nominalVoltageBaseVoltageMap.containsKey(nominalVoltage)) {
            if (this.nominalVoltageBaseVoltageMap.get(nominalVoltage).getSource().equals((Object)Source.IGM) && source.equals((Object)Source.BOUNDARY)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Nominal voltage {} is already mapped with an {} base voltage. Replaced by a {} base voltage", new Object[]{nominalVoltage, Source.IGM.name(), Source.BOUNDARY.name()});
                }
                this.nominalVoltageBaseVoltageMap.put(nominalVoltage, new BaseVoltageSourceImpl(baseVoltageId, nominalVoltage, source));
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Nominal voltage {} is already mapped and not to the given base voltage {} from {}", new Object[]{nominalVoltage, baseVoltageId, source.name()});
            }
        } else {
            this.nominalVoltageBaseVoltageMap.put(nominalVoltage, new BaseVoltageSourceImpl(baseVoltageId, nominalVoltage, source));
        }
        return this;
    }

    @Override
    public Map<Double, BaseVoltageMapping.BaseVoltageSource> baseVoltagesByNominalVoltageMap() {
        return new HashMap<Double, BaseVoltageMapping.BaseVoltageSource>(this.nominalVoltageBaseVoltageMap);
    }

    static class BaseVoltageSourceImpl
    implements BaseVoltageMapping.BaseVoltageSource {
        private final String id;
        private final double nominalV;
        private final Source source;

        BaseVoltageSourceImpl(String id, double nominalV, Source source) {
            this.id = Objects.requireNonNull(id);
            this.nominalV = nominalV;
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public double getNominalV() {
            return this.nominalV;
        }

        @Override
        public Source getSource() {
            return this.source;
        }
    }
}

