/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.cgmes.extensions.BaseVoltageMapping;
import com.powsybl.cgmes.extensions.BaseVoltageMappingAdder;
import com.powsybl.cgmes.extensions.Source;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Network;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

@AutoService(value=ExtensionXmlSerializer.class)
public class BaseVoltageMappingXmlSerializer
extends AbstractExtensionXmlSerializer<Network, BaseVoltageMapping> {
    public BaseVoltageMappingXmlSerializer() {
        super("baseVoltageMapping", "network", BaseVoltageMapping.class, true, "baseVoltageMapping.xsd", "http://www.powsybl.org/schema/iidm/ext/base_voltage_mapping/1_0", "bv");
    }

    public void write(BaseVoltageMapping extension, XmlWriterContext context) throws XMLStreamException {
        Map sortedBaseVoltages = extension.getBaseVoltages().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        sortedBaseVoltages.forEach((nominalV, baseVoltageSource) -> {
            try {
                context.getWriter().writeEmptyElement(this.getNamespaceUri(), "baseVoltage");
                context.getWriter().writeAttribute("nominalVoltage", Double.toString(nominalV));
                context.getWriter().writeAttribute("source", baseVoltageSource.getSource().name());
                context.getWriter().writeAttribute("id", baseVoltageSource.getId());
            }
            catch (XMLStreamException e) {
                throw new UncheckedXmlStreamException(e);
            }
        });
    }

    public BaseVoltageMapping read(Network extendable, XmlReaderContext context) throws XMLStreamException {
        BaseVoltageMappingAdder mappingAdder = (BaseVoltageMappingAdder)extendable.newExtension(BaseVoltageMappingAdder.class);
        mappingAdder.add();
        BaseVoltageMapping mapping = (BaseVoltageMapping)extendable.getExtension(BaseVoltageMapping.class);
        XmlUtil.readUntilEndElement((String)this.getName(), (XMLStreamReader)context.getReader(), () -> {
            if (!context.getReader().getLocalName().equals("baseVoltage")) {
                throw new PowsyblException("Unknown element name <" + context.getReader().getLocalName() + "> in <baseVoltageMapping>");
            }
            double nominalV = Double.parseDouble(context.getReader().getAttributeValue(null, "nominalVoltage"));
            String sourceBV = context.getReader().getAttributeValue(null, "source");
            String baseVoltageId = context.getReader().getAttributeValue(null, "id");
            mapping.addBaseVoltage(nominalV, baseVoltageId, Source.valueOf(sourceBV));
        });
        return mapping;
    }

    public boolean isSerializable(BaseVoltageMapping extension) {
        return !extension.isBaseVoltageEmpty();
    }
}

