/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.powsybl.cgmes.extensions.CgmesControlArea;
import com.powsybl.cgmes.extensions.CgmesControlAreasImpl;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.Terminal;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

class CgmesControlAreaImpl
implements CgmesControlArea {
    private final String id;
    private final String name;
    private final String energyIdentificationCodeEic;
    private final Set<Terminal> terminals = new LinkedHashSet<Terminal>();
    private final Set<Boundary> boundaries = new LinkedHashSet<Boundary>();
    private final double netInterchange;

    CgmesControlAreaImpl(String id, String name, String energyIdentificationCodeEic, double netInterchange, CgmesControlAreasImpl mapping) {
        this.id = Objects.requireNonNull(id);
        this.name = name;
        this.energyIdentificationCodeEic = energyIdentificationCodeEic;
        this.netInterchange = netInterchange;
        this.attach(mapping);
    }

    private void attach(CgmesControlAreasImpl mapping) {
        mapping.putCgmesControlArea(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEnergyIdentificationCodeEIC() {
        return this.energyIdentificationCodeEic;
    }

    @Override
    public Set<Terminal> getTerminals() {
        return Collections.unmodifiableSet(this.terminals);
    }

    @Override
    public Set<Boundary> getBoundaries() {
        return Collections.unmodifiableSet(this.boundaries);
    }

    @Override
    public double getNetInterchange() {
        return this.netInterchange;
    }

    @Override
    public void add(Terminal terminal) {
        this.terminals.add(terminal);
    }

    @Override
    public void add(Boundary boundary) {
        this.boundaries.add(boundary);
    }
}

