/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.cgmes.extensions.CgmesControlArea;
import com.powsybl.cgmes.extensions.CgmesControlAreas;
import com.powsybl.cgmes.extensions.CgmesControlAreasAdder;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.TerminalRefXml;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value=ExtensionXmlSerializer.class)
public class CgmesControlAreasXmlSerializer
extends AbstractExtensionXmlSerializer<Network, CgmesControlAreas> {
    private static final String CONTROL_AREA = "controlArea";

    public CgmesControlAreasXmlSerializer() {
        super("cgmesControlAreas", "network", CgmesControlAreas.class, true, "cgmesControlAreas.xsd", "http://www.powsybl.org/schema/iidm/ext/cgmes_control_areas/1_0", "cca");
    }

    public boolean isSerializable(CgmesControlAreas extension) {
        return !extension.getCgmesControlAreas().isEmpty();
    }

    public void write(CgmesControlAreas extension, XmlWriterContext context) throws XMLStreamException {
        NetworkXmlWriterContext networkContext = (NetworkXmlWriterContext)context;
        XMLStreamWriter writer = networkContext.getWriter();
        for (CgmesControlArea controlArea : extension.getCgmesControlAreas()) {
            writer.writeStartElement(this.getNamespaceUri(), CONTROL_AREA);
            writer.writeAttribute("id", controlArea.getId());
            writer.writeAttribute("name", controlArea.getName());
            if (controlArea.getEnergyIdentificationCodeEIC() != null) {
                writer.writeAttribute("energyIdentificationCodeEic", controlArea.getEnergyIdentificationCodeEIC());
            }
            XmlUtil.writeDouble((String)"netInterchange", (double)controlArea.getNetInterchange(), (XMLStreamWriter)writer);
            for (Terminal terminal : controlArea.getTerminals()) {
                TerminalRefXml.writeTerminalRef((Terminal)terminal, (NetworkXmlWriterContext)networkContext, (String)this.getNamespaceUri(), (String)"terminal");
            }
            for (Boundary boundary : controlArea.getBoundaries()) {
                if (boundary.getConnectable() == null) continue;
                writer.writeEmptyElement(this.getNamespaceUri(), "boundary");
                writer.writeAttribute("id", networkContext.getAnonymizer().anonymizeString(boundary.getConnectable().getId()));
                if (boundary.getSide() == null) continue;
                writer.writeAttribute("side", boundary.getSide().name());
            }
            writer.writeEndElement();
        }
    }

    public CgmesControlAreas read(Network extendable, XmlReaderContext context) throws XMLStreamException {
        NetworkXmlReaderContext networkContext = (NetworkXmlReaderContext)context;
        XMLStreamReader reader = networkContext.getReader();
        ((CgmesControlAreasAdder)extendable.newExtension(CgmesControlAreasAdder.class)).add();
        CgmesControlAreas mapping = (CgmesControlAreas)extendable.getExtension(CgmesControlAreas.class);
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)reader, () -> {
            if (!reader.getLocalName().equals(CONTROL_AREA)) {
                throw new PowsyblException("Unknown element name <" + reader.getLocalName() + "> in <cgmesControlArea>");
            }
            CgmesControlArea cgmesControlArea = mapping.newCgmesControlArea().setId(reader.getAttributeValue(null, "id")).setName(reader.getAttributeValue(null, "name")).setEnergyIdentificationCodeEic(reader.getAttributeValue(null, "energyIdentificationCodeEic")).setNetInterchange(XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"netInterchange")).add();
            this.readBoundariesAndTerminals(networkContext, reader, cgmesControlArea, extendable);
        });
        return (CgmesControlAreas)extendable.getExtension(CgmesControlAreas.class);
    }

    private void readBoundariesAndTerminals(NetworkXmlReaderContext networkContext, XMLStreamReader reader, CgmesControlArea cgmesControlArea, Network network) throws XMLStreamException {
        XmlUtil.readUntilEndElement((String)CONTROL_AREA, (XMLStreamReader)reader, () -> {
            switch (reader.getLocalName()) {
                case "boundary": {
                    String id = networkContext.getAnonymizer().deanonymizeString(networkContext.getReader().getAttributeValue(null, "id"));
                    Identifiable identifiable = network.getIdentifiable(id);
                    if (identifiable instanceof DanglingLine) {
                        DanglingLine dl = (DanglingLine)identifiable;
                        cgmesControlArea.add(dl.getBoundary());
                        break;
                    }
                    if (identifiable instanceof TieLine) {
                        String side = networkContext.getReader().getAttributeValue(null, "side");
                        TieLine tl = (TieLine)identifiable;
                        cgmesControlArea.add(tl.getHalf(Branch.Side.valueOf((String)side)).getBoundary());
                        break;
                    }
                    throw new PowsyblException("Unexpected Identifiable instance: " + identifiable.getClass());
                }
                case "terminal": {
                    String id = networkContext.getAnonymizer().deanonymizeString(networkContext.getReader().getAttributeValue(null, "id"));
                    String side = networkContext.getReader().getAttributeValue(null, "side");
                    cgmesControlArea.add(TerminalRefXml.readTerminalRef((Network)network, (String)id, (String)side));
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name <" + reader.getLocalName() + "> in <controlArea>");
                }
            }
        });
    }
}

