/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.powsybl.cgmes.extensions.CgmesTapChanger;
import com.powsybl.cgmes.extensions.CgmesTapChangerAdder;
import com.powsybl.cgmes.extensions.CgmesTapChangerAdderImpl;
import com.powsybl.cgmes.extensions.CgmesTapChangerImpl;
import com.powsybl.cgmes.extensions.CgmesTapChangers;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.iidm.network.Connectable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class CgmesTapChangersImpl<C extends Connectable<C>>
extends AbstractExtension<C>
implements CgmesTapChangers<C> {
    private final Map<String, CgmesTapChanger> tapChangers = new HashMap<String, CgmesTapChanger>();

    CgmesTapChangersImpl(C transformer) {
        super(transformer);
    }

    @Override
    public Set<CgmesTapChanger> getTapChangers() {
        return this.tapChangers.values().stream().sorted(Comparator.comparing(CgmesTapChanger::getId)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public CgmesTapChanger getTapChanger(String id) {
        return this.tapChangers.get(id);
    }

    @Override
    public CgmesTapChangerAdder newTapChanger() {
        return new CgmesTapChangerAdderImpl(this);
    }

    void putTapChanger(CgmesTapChangerImpl tapChanger) {
        String tapChangerId = tapChanger.getId();
        if (this.tapChangers.containsKey(tapChangerId)) {
            throw new PowsyblException(String.format("Tap changer %s has already been added", tapChangerId));
        }
        this.tapChangers.put(tapChangerId, tapChanger);
    }
}

