/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.cgmes.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.cgmes.extensions.CgmesTapChanger;
import com.powsybl.cgmes.extensions.CgmesTapChangerAdder;
import com.powsybl.cgmes.extensions.CgmesTapChangers;
import com.powsybl.cgmes.extensions.CgmesTapChangersAdder;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value=ExtensionXmlSerializer.class)
public class CgmesTapChangersXmlSerializer<C extends Connectable<C>>
extends AbstractExtensionXmlSerializer<C, CgmesTapChangers<C>> {
    public CgmesTapChangersXmlSerializer() {
        super("cgmesTapChangers", "network", CgmesTapChangers.class, true, "cgmesTapChangers.xsd", "http://www.powsybl.org/schema/iidm/ext/cgmes_tap_changers/1_0", "ctc");
    }

    public void write(CgmesTapChangers<C> extension, XmlWriterContext context) throws XMLStreamException {
        NetworkXmlWriterContext networkContext = (NetworkXmlWriterContext)context;
        XMLStreamWriter writer = networkContext.getWriter();
        for (CgmesTapChanger tapChanger : extension.getTapChangers()) {
            writer.writeStartElement(this.getNamespaceUri(), "tapChanger");
            writer.writeAttribute("id", tapChanger.getId());
            if (tapChanger.getCombinedTapChangerId() != null) {
                writer.writeAttribute("combinedTapChangerId", tapChanger.getCombinedTapChangerId());
            }
            if (tapChanger.getType() != null) {
                writer.writeAttribute("type", tapChanger.getType());
            }
            if (tapChanger.isHidden()) {
                writer.writeAttribute("hidden", "true");
                writer.writeAttribute("step", String.valueOf(tapChanger.getStep().orElseThrow(() -> new PowsyblException("Step should be defined"))));
            }
            if (tapChanger.getControlId() != null) {
                writer.writeAttribute("controlId", tapChanger.getControlId());
            }
            writer.writeEndElement();
        }
    }

    public CgmesTapChangers<C> read(C extendable, XmlReaderContext context) throws XMLStreamException {
        NetworkXmlReaderContext networkContext = (NetworkXmlReaderContext)context;
        XMLStreamReader reader = networkContext.getReader();
        ((CgmesTapChangersAdder)extendable.newExtension(CgmesTapChangersAdder.class)).add();
        CgmesTapChangers tapChangers = (CgmesTapChangers)extendable.getExtension(CgmesTapChangers.class);
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)reader, () -> {
            CgmesTapChangerAdder adder;
            if (reader.getLocalName().equals("tapChanger")) {
                adder = tapChangers.newTapChanger().setId(reader.getAttributeValue(null, "id")).setCombinedTapChangerId(reader.getAttributeValue(null, "combinedTapChangerId")).setType(reader.getAttributeValue(null, "type")).setHiddenStatus(XmlUtil.readOptionalBoolAttribute((XMLStreamReader)reader, (String)"hidden", (boolean)false)).setControlId(reader.getAttributeValue(null, "controlId"));
                String stepStr = reader.getAttributeValue(null, "step");
                if (stepStr != null) {
                    adder.setStep(Integer.parseInt(stepStr));
                }
            } else {
                throw new PowsyblException("Unknown element name <" + reader.getLocalName() + "> in <cgmesTapChangers>");
            }
            adder.add();
        });
        return (CgmesTapChangers)extendable.getExtension(CgmesTapChangers.class);
    }
}

