/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.extensions;

import java.util.Objects;

public class Coordinate {
    private final double latitude;
    private final double longitude;

    public Coordinate(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Coordinate(Coordinate coordinate) {
        Objects.requireNonNull(coordinate);
        this.longitude = coordinate.getLongitude();
        this.latitude = coordinate.getLatitude();
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinate that = (Coordinate)o;
        return Double.compare(that.latitude, this.latitude) == 0 && Double.compare(that.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public String toString() {
        return "Coordinate(lat=" + this.latitude + ", lon=" + this.longitude + ")";
    }
}

