/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Network;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public interface SecondaryVoltageControl
extends Extension<Network> {
    public static final String NAME = "secondaryVoltageControl";

    public List<ControlZone> getControlZones();

    default public String getName() {
        return NAME;
    }

    public static class ControlZone {
        private final String name;
        private final PilotPoint pilotPoint;
        private final List<ControlUnit> controlUnits = new ArrayList<ControlUnit>();

        public ControlZone(String name, PilotPoint pilotPoint, List<ControlUnit> controlUnits) {
            this.name = Objects.requireNonNull(name);
            this.pilotPoint = Objects.requireNonNull(pilotPoint);
            Objects.requireNonNull(controlUnits).forEach(Objects::requireNonNull);
            if (controlUnits.isEmpty()) {
                throw new PowsyblException("Empty control unit list");
            }
            this.controlUnits.addAll(controlUnits);
        }

        public String getName() {
            return this.name;
        }

        public PilotPoint getPilotPoint() {
            return this.pilotPoint;
        }

        public List<ControlUnit> getControlUnits() {
            return Collections.unmodifiableList(this.controlUnits);
        }
    }

    public static class ControlUnit {
        private final String id;
        private boolean participate;

        public ControlUnit(String id) {
            this(id, true);
        }

        public ControlUnit(String id, boolean participate) {
            this.id = Objects.requireNonNull(id);
            this.participate = participate;
        }

        public String getId() {
            return this.id;
        }

        public boolean isParticipate() {
            return this.participate;
        }

        public void setParticipate(boolean participate) {
            this.participate = participate;
        }
    }

    public static class PilotPoint {
        private final List<String> busbarSectionsOrBusesIds = new ArrayList<String>();
        private double targetV;

        public PilotPoint(List<String> busbarSectionsOrBusesIds, double targetV) {
            Objects.requireNonNull(busbarSectionsOrBusesIds).forEach(Objects::requireNonNull);
            if (busbarSectionsOrBusesIds.isEmpty()) {
                throw new PowsyblException("Empty busbar section of bus ID list");
            }
            this.busbarSectionsOrBusesIds.addAll(busbarSectionsOrBusesIds);
            if (Double.isNaN(targetV)) {
                throw new PowsyblException("Invalid target voltage");
            }
            this.targetV = targetV;
        }

        public List<String> getBusbarSectionsOrBusesIds() {
            return Collections.unmodifiableList(this.busbarSectionsOrBusesIds);
        }

        public double getTargetV() {
            return this.targetV;
        }

        public void setTargetV(double targetV) {
            this.targetV = targetV;
        }
    }
}

