/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TieLineAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.test.TerminalMockExt;
import org.joda.time.DateTime;

public final class EurostagTutorialExample1Factory {
    private static final String VLGEN = "VLGEN";

    private EurostagTutorialExample1Factory() {
    }

    public static Network create() {
        return EurostagTutorialExample1Factory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Network network = networkFactory.createNetwork("sim1", "test");
        Substation p1 = ((SubstationAdder)network.newSubstation().setId("P1")).setCountry(Country.FR).setTso("RTE").setGeographicalTags(new String[]{"A"}).add();
        Substation p2 = ((SubstationAdder)network.newSubstation().setId("P2")).setCountry(Country.FR).setTso("RTE").setGeographicalTags(new String[]{"B"}).add();
        VoltageLevel vlgen = ((VoltageLevelAdder)p1.newVoltageLevel().setId(VLGEN)).setNominalV(24.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        VoltageLevel vlhv1 = ((VoltageLevelAdder)p1.newVoltageLevel().setId("VLHV1")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        VoltageLevel vlhv2 = ((VoltageLevelAdder)p2.newVoltageLevel().setId("VLHV2")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        VoltageLevel vlload = ((VoltageLevelAdder)p2.newVoltageLevel().setId("VLLOAD")).setNominalV(150.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus ngen = ((BusAdder)vlgen.getBusBreakerView().newBus().setId("NGEN")).add();
        Bus nhv1 = ((BusAdder)vlhv1.getBusBreakerView().newBus().setId("NHV1")).add();
        Bus nhv2 = ((BusAdder)vlhv2.getBusBreakerView().newBus().setId("NHV2")).add();
        Bus nload = ((BusAdder)vlload.getBusBreakerView().newBus().setId("NLOAD")).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("NHV1_NHV2_1")).setVoltageLevel1(vlhv1.getId())).setBus1(nhv1.getId())).setConnectableBus1(nhv1.getId())).setVoltageLevel2(vlhv2.getId())).setBus2(nhv2.getId())).setConnectableBus2(nhv2.getId())).setR(3.0).setX(33.0).setG1(0.0).setB1(1.93E-4).setG2(0.0).setB2(1.93E-4).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("NHV1_NHV2_2")).setVoltageLevel1(vlhv1.getId())).setBus1(nhv1.getId())).setConnectableBus1(nhv1.getId())).setVoltageLevel2(vlhv2.getId())).setBus2(nhv2.getId())).setConnectableBus2(nhv2.getId())).setR(3.0).setX(33.0).setG1(0.0).setB1(1.93E-4).setG2(0.0).setB2(1.93E-4).add();
        int zb380 = 1444;
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)p1.newTwoWindingsTransformer().setId("NGEN_NHV1")).setVoltageLevel1(vlgen.getId())).setBus1(ngen.getId())).setConnectableBus1(ngen.getId())).setRatedU1(24.0).setVoltageLevel2(vlhv1.getId())).setBus2(nhv1.getId())).setConnectableBus2(nhv1.getId())).setRatedU2(400.0).setR(1.846153846153846E-4 * (double)zb380).setX(Math.sqrt(99.9424) / 1300.0 * (double)zb380).setG(0.0).setB(0.0).add();
        int zb150 = 225;
        TwoWindingsTransformer nhv2Nload = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)p2.newTwoWindingsTransformer().setId("NHV2_NLOAD")).setVoltageLevel1(vlhv2.getId())).setBus1(nhv2.getId())).setConnectableBus1(nhv2.getId())).setRatedU1(400.0).setVoltageLevel2(vlload.getId())).setBus2(nload.getId())).setConnectableBus2(nload.getId())).setRatedU2(158.0).setR(2.0999999999999998E-4 * (double)zb150).setX(Math.sqrt(323.9559) / 1000.0 * (double)zb150).setG(0.0).setB(0.0).add();
        double a = 1.0006666666666666;
        nhv2Nload.newRatioTapChanger().beginStep().setRho((double)0.85f * a).setR(0.0).setX(0.0).setG(0.0).setB(0.0).endStep().beginStep().setRho(a).setR(0.0).setX(0.0).setG(0.0).setB(0.0).endStep().beginStep().setRho((double)1.15f * a).setR(0.0).setX(0.0).setG(0.0).setB(0.0).endStep().setTapPosition(1).setLoadTapChangingCapabilities(true).setRegulating(true).setTargetV(158.0).setTargetDeadband(0.0).setRegulationTerminal(nhv2Nload.getTerminal2()).add();
        ((LoadAdder)((LoadAdder)((LoadAdder)vlload.newLoad().setId("LOAD")).setBus(nload.getId())).setConnectableBus(nload.getId())).setP0(600.0).setQ0(200.0).add();
        Generator generator = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vlgen.newGenerator().setId("GEN")).setBus(ngen.getId())).setConnectableBus(ngen.getId())).setMinP(-9999.99).setMaxP(9999.99).setVoltageRegulatorOn(true).setTargetV(24.5).setTargetP(607.0).setTargetQ(301.0).add();
        generator.newMinMaxReactiveLimits().setMinQ(-9999.99).setMaxQ(9999.99).add();
        return network;
    }

    public static Network createWithTieLine() {
        return EurostagTutorialExample1Factory.createWithTieLines(NetworkFactory.findDefault());
    }

    public static Network createWithTieLines(NetworkFactory networkFactory) {
        Network network = EurostagTutorialExample1Factory.createWithLFResults(networkFactory);
        network.getLine("NHV1_NHV2_1").remove();
        network.getLine("NHV1_NHV2_2").remove();
        ((TieLineAdder)((TieLineAdder)((TieLineAdder)((TieLineAdder)((TieLineAdder)network.newTieLine().setId("NHV1_NHV2_1")).setVoltageLevel1("VLHV1")).setBus1("NHV1")).setVoltageLevel2("VLHV2")).setBus2("NHV2")).setUcteXnodeCode("XNODE1").newHalfLine1().setId("NHV1_XNODE1").setR(1.5).setX(20.0).setG1(0.0).setG2(0.0).setB1(9.65E-5).setB2(9.65E-5).add().newHalfLine2().setId("XNODE1_NHV2").setR(1.5).setX(13.0).setG1(0.0).setG2(0.0).setB1(9.65E-5).setB2(9.65E-5).add().add();
        ((TieLineAdder)((TieLineAdder)((TieLineAdder)((TieLineAdder)((TieLineAdder)network.newTieLine().setId("NHV1_NHV2_2")).setVoltageLevel1("VLHV1")).setBus1("NHV1")).setVoltageLevel2("VLHV2")).setBus2("NHV2")).setUcteXnodeCode("XNODE2").newHalfLine1().setId("NVH1_XNODE2").setR(1.5).setX(20.0).setG1(0.0).setG2(0.0).setB1(9.65E-5).setB2(9.65E-5).add().newHalfLine2().setId("XNODE2_NHV2").setR(1.5).setX(13.0).setG1(0.0).setG2(0.0).setB1(9.65E-5).setB2(9.65E-5).add().add();
        network.getLine("NHV1_NHV2_1").getTerminal1().setP(302.4440612792969).setQ(98.74027252197266);
        network.getLine("NHV1_NHV2_1").getTerminal2().setP((double)-300.4339f).setQ(-137.18849182128906);
        network.getLine("NHV1_NHV2_2").getTerminal1().setP(302.4440612792969).setQ(98.74027252197266);
        network.getLine("NHV1_NHV2_2").getTerminal2().setP((double)-300.4339f).setQ(-137.18849182128906);
        return network;
    }

    public static Network createWithLFResults() {
        return EurostagTutorialExample1Factory.createWithLFResults(NetworkFactory.findDefault());
    }

    public static Network createWithLFResults(NetworkFactory factory) {
        Network network = EurostagTutorialExample1Factory.create(factory);
        network.setCaseDate(DateTime.parse((String)"2013-01-15T18:45:00.000+01:00"));
        network.getBusBreakerView().getBus("NGEN").setV(24.500000610351563).setAngle(2.3259763717651367);
        network.getBusBreakerView().getBus("NHV1").setV(402.1428451538086).setAngle(0.0);
        network.getBusBreakerView().getBus("NHV2").setV(389.9526763916016).setAngle(-3.5063576698303223);
        network.getBusBreakerView().getBus("NLOAD").setV(147.57861328125).setAngle(-9.614486694335938);
        network.getGenerator("GEN").getTerminal().setP(-605.558349609375).setQ(-225.2825164794922);
        network.getTwoWindingsTransformer("NGEN_NHV1").getTerminal1().setP(605.558349609375).setQ(225.2825164794922);
        network.getTwoWindingsTransformer("NGEN_NHV1").getTerminal2().setP(-604.8909301757812).setQ(-197.48046875);
        network.getLoad("LOAD").getTerminal().setP(600.0).setQ(200.0);
        network.getTwoWindingsTransformer("NHV2_NLOAD").getTerminal1().setP(600.8677978515625).setQ(274.3769836425781);
        network.getTwoWindingsTransformer("NHV2_NLOAD").getTerminal2().setP(-600.0).setQ(-200.0);
        network.getLine("NHV1_NHV2_1").getTerminal1().setP(302.4440612792969).setQ(98.74027252197266);
        network.getLine("NHV1_NHV2_1").getTerminal2().setP((double)-300.4339f).setQ(-137.18849182128906);
        network.getLine("NHV1_NHV2_2").getTerminal1().setP(302.4440612792969).setQ(98.74027252197266);
        network.getLine("NHV1_NHV2_2").getTerminal2().setP((double)-300.4339f).setQ(-137.18849182128906);
        return network;
    }

    public static Network createWithMoreGenerators() {
        return EurostagTutorialExample1Factory.createWithMoreGenerators(NetworkFactory.findDefault());
    }

    public static Network createWithMoreGenerators(NetworkFactory networkFactory) {
        Network network = EurostagTutorialExample1Factory.create(networkFactory);
        VoltageLevel vlgen = network.getVoltageLevel(VLGEN);
        Bus ngen = vlgen.getBusBreakerView().getBus("NGEN");
        Generator generator2 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vlgen.newGenerator().setId("GEN2")).setBus(ngen.getId())).setConnectableBus(ngen.getId())).setMinP(-9999.99).setMaxP(9999.99).setVoltageRegulatorOn(true).setTargetV(24.5).setTargetP(607.0).setTargetQ(301.0).add();
        generator2.newReactiveCapabilityCurve().beginPoint().setP(3.0).setMaxQ(5.0).setMinQ(4.0).endPoint().beginPoint().setP(0.0).setMaxQ(7.0).setMinQ(6.0).endPoint().beginPoint().setP(1.0).setMaxQ(5.0).setMinQ(4.0).endPoint().add();
        return network;
    }

    @Deprecated
    public static Network createWithCurrentLimits() {
        Network network = EurostagTutorialExample1Factory.createWithFixedCurrentLimits();
        Line line = network.getLine("NHV1_NHV2_1");
        ((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)line.newCurrentLimits2().setPermanentLimit(1100.0)).beginTemporaryLimit().setName("10'").setAcceptableDuration(600).setValue(1200.0).endTemporaryLimit()).beginTemporaryLimit().setName("1'").setAcceptableDuration(60).setValue(1500.0).endTemporaryLimit()).add();
        line = network.getLine("NHV1_NHV2_2");
        ((CurrentLimitsAdder)((CurrentLimitsAdder)line.newCurrentLimits1().setPermanentLimit(1100.0)).beginTemporaryLimit().setName("20'").setAcceptableDuration(1200).setValue(1200.0).endTemporaryLimit()).add();
        return network;
    }

    public static Network createWithFixedCurrentLimits() {
        return EurostagTutorialExample1Factory.createWithFixedCurrentLimits(NetworkFactory.findDefault());
    }

    public static Network createWithFixedCurrentLimits(NetworkFactory networkFactory) {
        Network network = EurostagTutorialExample1Factory.create(networkFactory);
        network.setCaseDate(DateTime.parse((String)"2018-01-01T11:00:00+01:00"));
        network.getSubstation("P2").setCountry(Country.BE);
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)network.getVoltageLevel(VLGEN).newGenerator().setId("GEN2")).setBus("NGEN")).setConnectableBus("NGEN")).setMinP(-9999.99).setMaxP(9999.99).setVoltageRegulatorOn(true).setTargetV(24.5).setTargetP(607.0).setTargetQ(301.0).add();
        ((Bus)network.getIdentifiable("NHV1")).setV(380.0).getVoltageLevel().setLowVoltageLimit(400.0).setHighVoltageLimit(500.0);
        ((Bus)network.getIdentifiable("NHV2")).setV(380.0).getVoltageLevel().setLowVoltageLimit(300.0).setHighVoltageLimit(500.0);
        Line line = network.getLine("NHV1_NHV2_1");
        line.getTerminal1().setP(560.0).setQ(550.0);
        line.getTerminal2().setP(-560.0).setQ(-550.0);
        ((CurrentLimitsAdder)line.newCurrentLimits1().setPermanentLimit(500.0)).add();
        ((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)line.newCurrentLimits2().setPermanentLimit(1100.0)).beginTemporaryLimit().setName("10'").setAcceptableDuration(600).setValue(1200.0).endTemporaryLimit()).beginTemporaryLimit().setName("1'").setAcceptableDuration(60).setValue(1500.0).endTemporaryLimit()).beginTemporaryLimit().setName("N/A").setAcceptableDuration(0).setValue(Double.MAX_VALUE).endTemporaryLimit()).add();
        line = network.getLine("NHV1_NHV2_2");
        line.getTerminal1().setP(560.0).setQ(550.0);
        line.getTerminal2().setP(-560.0).setQ(-550.0);
        ((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)line.newCurrentLimits1().setPermanentLimit(1100.0)).beginTemporaryLimit().setName("20'").setAcceptableDuration(1200).setValue(1200.0).endTemporaryLimit()).beginTemporaryLimit().setName("N/A").setAcceptableDuration(60).setValue(Double.MAX_VALUE).endTemporaryLimit()).add();
        ((CurrentLimitsAdder)line.newCurrentLimits2().setPermanentLimit(500.0)).add();
        return network;
    }

    public static Network createWithFixedLimits() {
        return EurostagTutorialExample1Factory.createWithFixedLimits(NetworkFactory.findDefault());
    }

    public static Network createWithFixedLimits(NetworkFactory networkFactory) {
        Network network = EurostagTutorialExample1Factory.create(networkFactory);
        network.setCaseDate(DateTime.parse((String)"2018-01-01T11:00:00+01:00"));
        network.getSubstation("P2").setCountry(Country.BE);
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)network.getVoltageLevel(VLGEN).newGenerator().setId("GEN2")).setBus("NGEN")).setConnectableBus("NGEN")).setMinP(-9999.99).setMaxP(9999.99).setVoltageRegulatorOn(true).setTargetV(24.5).setTargetP(607.0).setTargetQ(301.0).add();
        ((Bus)network.getIdentifiable("NHV1")).setV(380.0).getVoltageLevel().setLowVoltageLimit(400.0).setHighVoltageLimit(500.0);
        ((Bus)network.getIdentifiable("NHV2")).setV(380.0).getVoltageLevel().setLowVoltageLimit(300.0).setHighVoltageLimit(500.0);
        Line line = network.getLine("NHV1_NHV2_1");
        line.getTerminal1().setP(560.0).setQ(550.0);
        line.getTerminal2().setP(560.0).setQ(550.0);
        ((ActivePowerLimitsAdder)line.newActivePowerLimits1().setPermanentLimit(500.0)).add();
        ((ActivePowerLimitsAdder)((ActivePowerLimitsAdder)((ActivePowerLimitsAdder)((ActivePowerLimitsAdder)line.newActivePowerLimits2().setPermanentLimit(1100.0)).beginTemporaryLimit().setName("10'").setAcceptableDuration(600).setValue(1200.0).endTemporaryLimit()).beginTemporaryLimit().setName("1'").setAcceptableDuration(60).setValue(1500.0).endTemporaryLimit()).beginTemporaryLimit().setName("N/A").setAcceptableDuration(0).setValue(Double.MAX_VALUE).endTemporaryLimit()).add();
        ((ApparentPowerLimitsAdder)line.newApparentPowerLimits1().setPermanentLimit(500.0)).add();
        ((ApparentPowerLimitsAdder)((ApparentPowerLimitsAdder)((ApparentPowerLimitsAdder)((ApparentPowerLimitsAdder)line.newApparentPowerLimits2().setPermanentLimit(1100.0)).beginTemporaryLimit().setName("10'").setAcceptableDuration(600).setValue(1200.0).endTemporaryLimit()).beginTemporaryLimit().setName("1'").setAcceptableDuration(60).setValue(1500.0).endTemporaryLimit()).beginTemporaryLimit().setName("N/A").setAcceptableDuration(0).setValue(Double.MAX_VALUE).endTemporaryLimit()).add();
        line = network.getLine("NHV1_NHV2_2");
        line.getTerminal1().setP(560.0).setQ(550.0);
        line.getTerminal2().setP(560.0).setQ(550.0);
        ((ActivePowerLimitsAdder)((ActivePowerLimitsAdder)((ActivePowerLimitsAdder)line.newActivePowerLimits1().setPermanentLimit(1100.0)).beginTemporaryLimit().setName("20'").setAcceptableDuration(1200).setValue(1200.0).endTemporaryLimit()).beginTemporaryLimit().setName("N/A").setAcceptableDuration(60).setValue(Double.MAX_VALUE).endTemporaryLimit()).add();
        ((ActivePowerLimitsAdder)line.newActivePowerLimits2().setPermanentLimit(500.0)).add();
        ((ApparentPowerLimitsAdder)((ApparentPowerLimitsAdder)((ApparentPowerLimitsAdder)line.newApparentPowerLimits1().setPermanentLimit(1100.0)).beginTemporaryLimit().setName("20'").setAcceptableDuration(1200).setValue(1200.0).endTemporaryLimit()).beginTemporaryLimit().setName("N/A").setAcceptableDuration(60).setValue(Double.MAX_VALUE).endTemporaryLimit()).add();
        ((ApparentPowerLimitsAdder)line.newApparentPowerLimits2().setPermanentLimit(500.0)).add();
        return network;
    }

    public static Network createWithMultipleConnectedComponents() {
        return EurostagTutorialExample1Factory.createWithMultipleConnectedComponents(NetworkFactory.findDefault());
    }

    public static Network createWithMultipleConnectedComponents(NetworkFactory networkFactory) {
        Network network = EurostagTutorialExample1Factory.create(networkFactory);
        Substation p3 = ((SubstationAdder)network.newSubstation().setId("P3")).setCountry(Country.FR).add();
        VoltageLevel vlhv3 = ((VoltageLevelAdder)p3.newVoltageLevel().setId("VLHV3")).setNominalV(24.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus nconnected = ((BusAdder)vlhv3.getBusBreakerView().newBus().setId("N1")).add();
        Bus ndisconnected = ((BusAdder)vlhv3.getBusBreakerView().newBus().setId("N2")).add();
        Bus nshunt = ((BusAdder)vlhv3.getBusBreakerView().newBus().setId("NSHUNT")).add();
        ((LoadAdder)((LoadAdder)((LoadAdder)vlhv3.newLoad().setId("LOAD2")).setBus(nconnected.getId())).setConnectableBus(nconnected.getId())).setP0(600.0).setQ0(200.0).add();
        ((LoadAdder)((LoadAdder)vlhv3.newLoad().setId("LOAD3")).setConnectableBus(ndisconnected.getId())).setP0(600.0).setQ0(200.0).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vlhv3.newGenerator().setId("GEN2")).setBus(nconnected.getId())).setConnectableBus(nconnected.getId())).setMinP(-9999.99).setMaxP(9999.99).setVoltageRegulatorOn(true).setTargetV(24.5).setTargetP(607.0).setTargetQ(301.0).add();
        ((GeneratorAdder)((GeneratorAdder)vlhv3.newGenerator().setId("GEN3")).setConnectableBus(ndisconnected.getId())).setMinP(-9999.99).setMaxP(9999.99).setVoltageRegulatorOn(true).setTargetV(24.5).setTargetP(607.0).setTargetQ(301.0).add();
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)vlhv3.newShuntCompensator().setId("SHUNT")).setConnectableBus(nshunt.getId())).setSectionCount(1).newLinearModel().setBPerSection(1.0E-5).setMaximumSectionCount(1).add().add();
        return network;
    }

    public static Network createWithTerminalMockExt() {
        return EurostagTutorialExample1Factory.createWithTerminalMockExt(NetworkFactory.findDefault());
    }

    public static Network createWithTerminalMockExt(NetworkFactory networkFactory) {
        Network network = EurostagTutorialExample1Factory.create(networkFactory);
        network.setCaseDate(DateTime.parse((String)"2013-01-15T18:45:00.000+01:00"));
        Load load = network.getLoad("LOAD");
        TerminalMockExt terminalMockExt = new TerminalMockExt(load);
        load.addExtension(TerminalMockExt.class, (Extension)terminalMockExt);
        return network;
    }
}

