/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import java.util.Objects;
import org.joda.time.DateTime;

public final class FourSubstationsNodeBreakerFactory {
    private FourSubstationsNodeBreakerFactory() {
    }

    public static Network create() {
        return FourSubstationsNodeBreakerFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork("fourSubstations", "test");
        network.setCaseDate(DateTime.parse((String)"2017-06-25T17:43:00.000+01:00"));
        network.setForecastDistance(0);
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).add();
        VoltageLevel s1vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("S1VL1")).setNominalV(225.0).setLowVoltageLimit(220.0).setHighVoltageLimit(240.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        BusbarSection busbarSectionS1VL1 = ((BusbarSectionAdder)((BusbarSectionAdder)s1vl1.getNodeBreakerView().newBusbarSection().setId("S1VL1_BBS")).setName("S1VL1_BBS")).setNode(0).add();
        VoltageLevel s1vl2 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("S1VL2")).setNominalV(400.0).setLowVoltageLimit(390.0).setHighVoltageLimit(440.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        BusbarSection busbarSectionS1VL21 = ((BusbarSectionAdder)((BusbarSectionAdder)s1vl2.getNodeBreakerView().newBusbarSection().setId("S1VL2_BBS1")).setName("S1VL2_BBS1")).setNode(0).add();
        BusbarSection busbarSectionS1VL22 = ((BusbarSectionAdder)((BusbarSectionAdder)s1vl2.getNodeBreakerView().newBusbarSection().setId("S1VL2_BBS2")).setName("S1VL2_BBS2")).setNode(1).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).add();
        VoltageLevel s2vl1 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("S2VL1")).setNominalV(400.0).setLowVoltageLimit(390.0).setHighVoltageLimit(440.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        BusbarSection busbarSectionS2VL1 = ((BusbarSectionAdder)((BusbarSectionAdder)s2vl1.getNodeBreakerView().newBusbarSection().setId("S2VL1_BBS")).setName("S2VL1_BBS")).setNode(0).add();
        Substation s3 = ((SubstationAdder)network.newSubstation().setId("S3")).add();
        VoltageLevel s3vl1 = ((VoltageLevelAdder)s3.newVoltageLevel().setId("S3VL1")).setNominalV(400.0).setLowVoltageLimit(390.0).setHighVoltageLimit(440.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        BusbarSection busbarSectionS3VL1 = ((BusbarSectionAdder)((BusbarSectionAdder)s3vl1.getNodeBreakerView().newBusbarSection().setId("S3VL1_BBS")).setName("S3VL1_BBS")).setNode(0).add();
        Substation s4 = ((SubstationAdder)network.newSubstation().setId("S4")).add();
        VoltageLevel s4vl1 = ((VoltageLevelAdder)s4.newVoltageLevel().setId("S4VL1")).setNominalV(400.0).setLowVoltageLimit(390.0).setHighVoltageLimit(440.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        BusbarSection busbarSectionS4VL1 = ((BusbarSectionAdder)((BusbarSectionAdder)s4vl1.getNodeBreakerView().newBusbarSection().setId("S4VL1_BBS")).setName("S4VL1_BBS")).setNode(0).add();
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl1, "S1VL1_BBS_LD1_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 1);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl1, "S1VL1_LD1_BREAKER", SwitchKind.BREAKER, false, 1, 2);
        Load load1 = ((LoadAdder)((LoadAdder)s1vl1.newLoad().setId("LD1")).setLoadType(LoadType.UNDEFINED).setP0(80.0).setQ0(10.0).setNode(2)).add();
        load1.getTerminal().setP(80.0).setQ(10.0);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl1, "S1VL1_BBS_TWT_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 3);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl1, "S1VL1_TWT_BREAKER", SwitchKind.BREAKER, false, 3, 4);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS1_TWT_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 2);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS2_TWT_DISCONNECTOR", SwitchKind.DISCONNECTOR, true, 1, 2);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_TWT_BREAKER", SwitchKind.BREAKER, false, 2, 3);
        TwoWindingsTransformer twt = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s1.newTwoWindingsTransformer().setId("TWT")).setR(2.0).setX(14.745).setG(0.0).setB(3.2E-5).setRatedU1(225.0).setRatedU2(400.0).setNode1(4)).setVoltageLevel1("S1VL1")).setNode2(3)).setVoltageLevel2("S1VL2")).add();
        ((CurrentLimitsAdder)twt.newCurrentLimits1().setPermanentLimit(1031.0)).add();
        ((CurrentLimitsAdder)twt.newCurrentLimits2().setPermanentLimit(1031.0)).add();
        twt.newPhaseTapChanger().setLowTapPosition(0).setTapPosition(15).setRegulationMode(PhaseTapChanger.RegulationMode.FIXED_TAP).setRegulating(false).setRegulationTerminal(twt.getTerminal(Branch.Side.ONE)).beginStep().setR(39.78473).setX(29.784725).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-42.8).endStep().beginStep().setR(31.720245).setX(21.720242).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-40.18).endStep().beginStep().setR(23.655737).setX(13.655735).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-37.54).endStep().beginStep().setR(16.263271).setX(6.263268).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-34.9).endStep().beginStep().setR(9.542847).setX(4.542842).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-32.26).endStep().beginStep().setR(3.4944773).setX(3.4944773).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-29.6).endStep().beginStep().setR(-1.8818557).setX(-1.8818527).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-26.94).endStep().beginStep().setR(-7.258195).setX(-3.2581954).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-24.26).endStep().beginStep().setR(-11.962485).setX(-7.962484).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-21.58).endStep().beginStep().setR(-15.994745).setX(-11.994745).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-18.9).endStep().beginStep().setR(-19.354952).setX(-15.354952).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-16.22).endStep().beginStep().setR(-22.043127).setX(-22.043129).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-13.52).endStep().beginStep().setR(-24.73129).setX(-24.731287).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-10.82).endStep().beginStep().setR(-26.747417).setX(-26.747417).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-8.12).endStep().beginStep().setR(-28.091503).setX(-28.091503).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-5.42).endStep().beginStep().setR(-28.763538).setX(-28.763536).setG(0.0).setB(0.0).setRho(1.0).setAlpha(-2.7).endStep().beginStep().setR(-28.763538).setX(-28.763536).setG(0.0).setB(0.0).setRho(1.0).setAlpha(0.0).endStep().beginStep().setR(-28.763538).setX(-28.763536).setG(0.0).setB(0.0).setRho(1.0).setAlpha(2.7).endStep().beginStep().setR(-28.091503).setX(-28.091503).setG(0.0).setB(0.0).setRho(1.0).setAlpha(5.42).endStep().beginStep().setR(-26.747417).setX(-26.747417).setG(0.0).setB(0.0).setRho(1.0).setAlpha(8.12).endStep().beginStep().setR(-24.73129).setX(-24.731287).setG(0.0).setB(0.0).setRho(1.0).setAlpha(10.82).endStep().beginStep().setR(-22.043127).setX(-22.043129).setG(0.0).setB(0.0).setRho(1.0).setAlpha(13.52).endStep().beginStep().setR(-19.354952).setX(-19.354952).setG(0.0).setB(0.0).setRho(1.0).setAlpha(16.22).endStep().beginStep().setR(-15.994745).setX(-15.994745).setG(0.0).setB(0.0).setRho(1.0).setAlpha(18.9).endStep().beginStep().setR(-11.962485).setX(-11.962484).setG(0.0).setB(0.0).setRho(1.0).setAlpha(21.58).endStep().beginStep().setR(-7.258195).setX(-7.2581954).setG(0.0).setB(0.0).setRho(1.0).setAlpha(24.26).endStep().beginStep().setR(-1.8818557).setX(-1.8818527).setG(0.0).setB(0.0).setRho(1.0).setAlpha(26.94).endStep().beginStep().setR(3.4944773).setX(3.4944773).setG(0.0).setB(0.0).setRho(1.0).setAlpha(29.6).endStep().beginStep().setR(9.542847).setX(9.542842).setG(0.0).setB(0.0).setRho(1.0).setAlpha(32.26).endStep().beginStep().setR(16.263271).setX(16.263268).setG(0.0).setB(0.0).setRho(1.0).setAlpha(34.9).endStep().beginStep().setR(23.655737).setX(23.655735).setG(0.0).setB(0.0).setRho(1.0).setAlpha(37.54).endStep().beginStep().setR(31.720245).setX(31.720242).setG(0.0).setB(0.0).setRho(1.0).setAlpha(40.18).endStep().beginStep().setR(39.78473).setX(39.784725).setG(0.0).setB(0.0).setRho(1.0).setAlpha(42.8).endStep().add();
        twt.newRatioTapChanger().beginStep().setR(0.0).setX(0.0).setB(0.0).setG(0.0).setRho(0.85).endStep().beginStep().setR(0.0).setX(0.0).setB(0.0).setG(0.0).setRho(1.0).endStep().beginStep().setR(0.0).setX(0.0).setB(0.0).setG(0.0).setRho(1.15).endStep().setLowTapPosition(0).setTapPosition(1).setLoadTapChangingCapabilities(true).setRegulating(true).setTargetV(225.0).setTargetDeadband(0.0).setRegulationTerminal(twt.getTerminal(Branch.Side.ONE)).add();
        twt.getTerminal1().setP(-80.0).setQ(-10.0);
        twt.getTerminal2().setP(80.0809).setQ(5.4857);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS1_VSC1_DISCONNECTOR", SwitchKind.DISCONNECTOR, true, 0, 4);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS2_VSC1_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 1, 4);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_VSC1_BREAKER", SwitchKind.BREAKER, false, 4, 5);
        VscConverterStation vsc1 = ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)s1vl2.newVscConverterStation().setId("VSC1")).setName("VSC1")).setNode(5)).setLossFactor(1.1f)).setReactivePowerSetpoint(500.0).setVoltageSetpoint(400.0).setVoltageRegulatorOn(true).add();
        vsc1.newReactiveCapabilityCurve().beginPoint().setP(-100.0).setMinQ(-550.0).setMaxQ(570.0).endPoint().beginPoint().setP(100.0).setMinQ(-550.0).setMaxQ(570.0).endPoint().add();
        vsc1.getTerminal().setP(10.11).setQ(-512.0814);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS1_GH1_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 6);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS1_GH2_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 8);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS1_GH3_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 10);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS2_GH1_DISCONNECTOR", SwitchKind.DISCONNECTOR, true, 1, 6);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS2_GH2_DISCONNECTOR", SwitchKind.DISCONNECTOR, true, 1, 8);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS2_GH3_DISCONNECTOR", SwitchKind.DISCONNECTOR, true, 1, 10);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_GH1_BREAKER", SwitchKind.BREAKER, false, 6, 7);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_GH2_BREAKER", SwitchKind.BREAKER, false, 8, 9);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_GH3_BREAKER", SwitchKind.BREAKER, false, 10, 11);
        Generator generatorHydro1 = ((GeneratorAdder)((GeneratorAdder)s1vl2.newGenerator().setId("GH1")).setEnergySource(EnergySource.HYDRO).setMinP(0.0).setMaxP(100.0).setVoltageRegulatorOn(true).setTargetP(85.357).setTargetV(400.0).setTargetQ(512.081).setNode(7)).add();
        generatorHydro1.newReactiveCapabilityCurve().beginPoint().setP(0.0).setMinQ(-769.3).setMaxQ(860.0).endPoint().beginPoint().setP(100.0).setMinQ(-864.55).setMaxQ(946.25).endPoint().add();
        generatorHydro1.getTerminal().setP(-85.357).setQ(-512.0814);
        Generator generatorHydro2 = ((GeneratorAdder)((GeneratorAdder)s1vl2.newGenerator().setId("GH2")).setEnergySource(EnergySource.HYDRO).setMinP(0.0).setMaxP(200.0).setVoltageRegulatorOn(true).setTargetP(90.0).setTargetV(400.0).setTargetQ(512.081).setNode(9)).add();
        generatorHydro2.newReactiveCapabilityCurve().beginPoint().setP(0.0).setMinQ(-556.8).setMaxQ(557.4).endPoint().beginPoint().setP(200.0).setMinQ(-553.514).setMaxQ(536.4).endPoint().add();
        generatorHydro2.getTerminal().setP(-90.0).setQ(-512.0814);
        Generator generatorHydro3 = ((GeneratorAdder)((GeneratorAdder)s1vl2.newGenerator().setId("GH3")).setEnergySource(EnergySource.HYDRO).setMinP(0.0).setMaxP(200.0).setVoltageRegulatorOn(true).setTargetP(155.714).setTargetV(400.0).setTargetQ(512.081).setNode(11)).add();
        generatorHydro3.newReactiveCapabilityCurve().beginPoint().setP(0.0).setMinQ(-680.6).setMaxQ(688.1).endPoint().beginPoint().setP(200.0).setMinQ(-681.725).setMaxQ(716.3500004).endPoint().add();
        generatorHydro3.getTerminal().setP(-155.714).setQ(-512.0814);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS1_LD2_DISCONNECTOR", SwitchKind.DISCONNECTOR, true, 0, 12);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS1_LD3_DISCONNECTOR", SwitchKind.DISCONNECTOR, true, 0, 14);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS1_LD4_DISCONNECTOR", SwitchKind.DISCONNECTOR, true, 0, 16);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS2_LD2_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 1, 12);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS2_LD3_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 1, 14);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS2_LD4_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 1, 16);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_LD2_BREAKER", SwitchKind.BREAKER, false, 12, 13);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_LD3_BREAKER", SwitchKind.BREAKER, false, 14, 15);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_LD4_BREAKER", SwitchKind.BREAKER, false, 16, 17);
        Load load2 = ((LoadAdder)((LoadAdder)s1vl2.newLoad().setId("LD2")).setLoadType(LoadType.UNDEFINED).setP0(60.0).setQ0(5.0).setNode(13)).add();
        load2.getTerminal().setP(60.0).setQ(5.0);
        Load load3 = ((LoadAdder)((LoadAdder)s1vl2.newLoad().setId("LD3")).setLoadType(LoadType.UNDEFINED).setP0(60.0).setQ0(5.0).setNode(15)).add();
        load3.getTerminal().setP(60.0).setQ(5.0);
        Load load4 = ((LoadAdder)((LoadAdder)s1vl2.newLoad().setId("LD4")).setLoadType(LoadType.UNDEFINED).setP0(40.0).setQ0(5.0).setNode(17)).add();
        load4.getTerminal().setP(40.0).setQ(5.0);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS1_SHUNT_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 18);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS2_SHUNT_DISCONNECTOR", SwitchKind.DISCONNECTOR, true, 1, 18);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_SHUNT_BREAKER", SwitchKind.BREAKER, false, 18, 19);
        ShuntCompensator shunt = ((ShuntCompensatorAdder)((ShuntCompensatorAdder)s1vl2.newShuntCompensator().setId("SHUNT")).setNode(19)).setSectionCount(1).newLinearModel().setMaximumSectionCount(1).setBPerSection(-0.012).add().add();
        shunt.getTerminal().setQ(1920.0);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS1_LCC1_DISCONNECTOR", SwitchKind.DISCONNECTOR, true, 0, 20);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS2_LCC1_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 1, 20);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_LCC1_BREAKER", SwitchKind.BREAKER, false, 20, 21);
        LccConverterStation lcc1 = ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)s1vl2.newLccConverterStation().setId("LCC1")).setName("LCC1")).setNode(21)).setLossFactor(1.1f)).setPowerFactor(0.6f).add();
        lcc1.getTerminal().setP(80.88);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS1_COUPLER_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 22);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_BBS2_COUPLER_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 1, 23);
        FourSubstationsNodeBreakerFactory.createSwitch(s1vl2, "S1VL2_COUPLER", SwitchKind.BREAKER, false, 22, 23);
        FourSubstationsNodeBreakerFactory.createSwitch(s2vl1, "S2VL1_BBS_GTH1_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 1);
        FourSubstationsNodeBreakerFactory.createSwitch(s2vl1, "S2VL1_GTH1_BREAKER", SwitchKind.BREAKER, false, 1, 2);
        Generator generatorThermal1 = ((GeneratorAdder)((GeneratorAdder)s2vl1.newGenerator().setId("GTH1")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(100.0).setVoltageRegulatorOn(false).setTargetP(100.0).setTargetV(400.0).setTargetQ(70.0).setNode(2)).add();
        generatorThermal1.newReactiveCapabilityCurve().beginPoint().setP(0.0).setMinQ(-76.8).setMaxQ(77.4).endPoint().beginPoint().setP(100.0).setMinQ(-73.514).setMaxQ(76.4).endPoint().add();
        generatorThermal1.getTerminal().setP(-100.0).setQ(-70.0);
        FourSubstationsNodeBreakerFactory.createSwitch(s2vl1, "S2VL1_BBS_VSC2_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 3);
        FourSubstationsNodeBreakerFactory.createSwitch(s2vl1, "S2VL1_VSC2_BREAKER", SwitchKind.BREAKER, false, 3, 4);
        VscConverterStation vsc2 = ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)s2vl1.newVscConverterStation().setId("VSC2")).setName("VSC2")).setNode(4)).setLossFactor(1.1f)).setReactivePowerSetpoint(120.0).setVoltageSetpoint(0.0).setVoltageRegulatorOn(false).add();
        vsc2.newMinMaxReactiveLimits().setMinQ(-400.0).setMaxQ(500.0).add();
        vsc2.getTerminal().setP(-9.89).setQ(-120.0);
        ((HvdcLineAdder)((HvdcLineAdder)network.newHvdcLine().setId("HVDC1")).setName("HVDC1")).setConverterStationId1("VSC1").setConverterStationId2("VSC2").setR(1.0).setNominalV(400.0).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).setMaxP(300.0).setActivePowerSetpoint(10.0).add();
        FourSubstationsNodeBreakerFactory.createSwitch(s2vl1, "S2VL1_BBS_LINES2S3_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 5);
        FourSubstationsNodeBreakerFactory.createSwitch(s2vl1, "S2VL1_LINES2S3_BREAKER", SwitchKind.BREAKER, false, 5, 6);
        FourSubstationsNodeBreakerFactory.createSwitch(s3vl1, "S3VL1_BBS_LINES2S3_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 1);
        FourSubstationsNodeBreakerFactory.createSwitch(s3vl1, "S3VL1_LINES2S3_BREAKER", SwitchKind.BREAKER, false, 1, 2);
        Line lineS2S3 = ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("LINE_S2S3")).setR(0.009999999).setX(19.100000024).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).setNode1(6)).setVoltageLevel1("S2VL1")).setNode2(2)).setVoltageLevel2("S3VL1")).add();
        lineS2S3.getTerminal1().setP(109.8893).setQ(190.0229);
        lineS2S3.getTerminal2().setP(-109.8864).setQ(-184.5171);
        FourSubstationsNodeBreakerFactory.createSwitch(s3vl1, "S3VL1_BBS_LD5_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 3);
        FourSubstationsNodeBreakerFactory.createSwitch(s3vl1, "S3VL1_LD5_BREAKER", SwitchKind.BREAKER, false, 3, 4);
        Load load5 = ((LoadAdder)((LoadAdder)s3vl1.newLoad().setId("LD5")).setLoadType(LoadType.UNDEFINED).setP0(200.0).setQ0(5.0).setNode(4)).add();
        load5.getTerminal().setP(200.0).setQ(5.0);
        FourSubstationsNodeBreakerFactory.createSwitch(s3vl1, "S3VL1_BBS_GTH2_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 5);
        FourSubstationsNodeBreakerFactory.createSwitch(s3vl1, "S3VL1_GTH2_BREAKER", SwitchKind.BREAKER, false, 5, 6);
        Generator generatorThermal2 = ((GeneratorAdder)((GeneratorAdder)s3vl1.newGenerator().setId("GTH2")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(400.0).setVoltageRegulatorOn(true).setTargetP(250.9944).setTargetV(400.0).setTargetQ(71.8487).setNode(6)).add();
        generatorThermal2.newReactiveCapabilityCurve().beginPoint().setP(0.0).setMinQ(-169.3).setMaxQ(200.0).endPoint().beginPoint().setP(400.0).setMinQ(-174.55).setMaxQ(176.25).endPoint().add();
        generatorThermal2.getTerminal().setP(-250.9944).setQ(71.8487);
        FourSubstationsNodeBreakerFactory.createSwitch(s3vl1, "S3VL1_BBS_LINES3S4_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 7);
        FourSubstationsNodeBreakerFactory.createSwitch(s3vl1, "S3VL1_LINES3S4_BREAKER", SwitchKind.BREAKER, false, 7, 8);
        FourSubstationsNodeBreakerFactory.createSwitch(s4vl1, "S4VL1_BBS_LINES3S4_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 5);
        FourSubstationsNodeBreakerFactory.createSwitch(s4vl1, "S4VL1_LINES3S4_BREAKER", SwitchKind.BREAKER, false, 5, 6);
        Line lineS3S4 = ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("LINE_S3S4")).setR(0.009999999).setX(13.100000024).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).setNode1(8)).setVoltageLevel1("S3VL1")).setNode2(6)).setVoltageLevel2("S4VL1")).add();
        lineS3S4.getTerminal1().setP(240.0036).setQ(2.1751);
        lineS3S4.getTerminal2().setP(-240.0).setQ(2.5415);
        ((CurrentLimitsAdder)lineS3S4.newCurrentLimits1().setPermanentLimit(931.0)).add();
        ((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)lineS3S4.newCurrentLimits2().setPermanentLimit(931.0)).beginTemporaryLimit().setName("IST").setValue(1640.0).setFictitious(true).setAcceptableDuration(Integer.MAX_VALUE).endTemporaryLimit()).beginTemporaryLimit().setName("LD71").setValue(Double.MAX_VALUE).setAcceptableDuration(60).endTemporaryLimit()).add();
        FourSubstationsNodeBreakerFactory.createSwitch(s3vl1, "S3VL1_BBS_LCC2_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 9);
        FourSubstationsNodeBreakerFactory.createSwitch(s3vl1, "S3VL1_LCC2_BREAKER", SwitchKind.BREAKER, false, 9, 10);
        LccConverterStation lcc2 = ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)s3vl1.newLccConverterStation().setId("LCC2")).setName("LCC2")).setNode(10)).setLossFactor(1.1f)).setPowerFactor(0.6f).add();
        lcc2.getTerminal().setP(-79.12);
        ((HvdcLineAdder)((HvdcLineAdder)network.newHvdcLine().setId("HVDC2")).setName("HVDC2")).setConverterStationId1("LCC1").setConverterStationId2("LCC2").setR(1.0).setNominalV(400.0).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).setMaxP(300.0).setActivePowerSetpoint(80.0).add();
        FourSubstationsNodeBreakerFactory.createSwitch(s4vl1, "S4VL1_BBS_LD6_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 1);
        FourSubstationsNodeBreakerFactory.createSwitch(s4vl1, "S4VL1_LD6_BREAKER", SwitchKind.BREAKER, false, 1, 2);
        Load load6 = ((LoadAdder)((LoadAdder)s4vl1.newLoad().setId("LD6")).setLoadType(LoadType.UNDEFINED).setP0(240.0).setQ0(10.0).setNode(2)).add();
        load6.getTerminal().setP(240.0).setQ(10.0);
        FourSubstationsNodeBreakerFactory.createSwitch(s4vl1, "S4VL1_BBS_SVC_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 3);
        FourSubstationsNodeBreakerFactory.createSwitch(s4vl1, "S4VL1_SVC_BREAKER", SwitchKind.BREAKER, false, 3, 4);
        StaticVarCompensator svc = ((StaticVarCompensatorAdder)((StaticVarCompensatorAdder)s4vl1.newStaticVarCompensator().setId("SVC")).setNode(4)).setBmin(-0.05).setBmax(0.05).setRegulationMode(StaticVarCompensator.RegulationMode.VOLTAGE).setVoltageSetpoint(400.0).add();
        svc.getTerminal().setQ(-12.5415);
        busbarSectionS1VL1.getTerminal().getBusView().getBus().setV(224.6139).setAngle(2.2822);
        busbarSectionS1VL21.getTerminal().getBusView().getBus().setV(400.0).setAngle(0.0);
        busbarSectionS1VL22.getTerminal().getBusView().getBus().setV(400.0).setAngle(0.0);
        busbarSectionS2VL1.getTerminal().getBusView().getBus().setV(408.847).setAngle(0.7347);
        busbarSectionS3VL1.getTerminal().getBusView().getBus().setV(400.0).setAngle(0.0);
        busbarSectionS4VL1.getTerminal().getBusView().getBus().setV(400.0).setAngle(-1.1259);
        return network;
    }

    private static void createSwitch(VoltageLevel vl, String id, SwitchKind kind, boolean open, int node1, int node2) {
        ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)vl.getNodeBreakerView().newSwitch().setId(id)).setName(id)).setKind(kind).setRetained(kind.equals((Object)SwitchKind.BREAKER)).setOpen(open).setFictitious(false)).setNode1(node1).setNode2(node2).add();
    }
}

