/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import java.util.Objects;
import org.joda.time.DateTime;

public final class HvdcTestNetwork {
    private static final String DISCONNECTOR_NAME = "Disconnector";
    private static final String BREAKER_NAME = "Breaker";

    private HvdcTestNetwork() {
    }

    public static Network createBase() {
        return HvdcTestNetwork.createBase(NetworkFactory.findDefault());
    }

    private static Network createBase(NetworkFactory networkFactory) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork("hvdctest", "test");
        network.setCaseDate(DateTime.parse((String)"2016-06-27T16:34:55.930+02:00"));
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).setCountry(Country.FR).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL1")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("B1")).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).setCountry(Country.FR).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("VL2")).setNominalV(400.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        ((BusbarSectionAdder)((BusbarSectionAdder)vl2.getNodeBreakerView().newBusbarSection().setId("BBS1")).setName("BusbarSection")).setNode(0).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)vl2.getNodeBreakerView().newDisconnector().setId("DISC_BBS1_BK1")).setName(DISCONNECTOR_NAME)).setNode1(0).setNode2(1).setOpen(false).setRetained(false).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)vl2.getNodeBreakerView().newBreaker().setId("BK1")).setName(BREAKER_NAME)).setNode1(1).setNode2(2).setOpen(false).setRetained(true).add();
        return network;
    }

    private static void createLine(Network network) {
        ((HvdcLineAdder)((HvdcLineAdder)network.newHvdcLine().setId("L")).setName("HVDC")).setConverterStationId1("C1").setConverterStationId2("C2").setR(1.0).setNominalV(400.0).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER).setMaxP(300.0).setActivePowerSetpoint(280.0).add();
    }

    public static Network createVsc() {
        return HvdcTestNetwork.createVsc(NetworkFactory.findDefault());
    }

    public static Network createVsc(NetworkFactory networkFactory) {
        Network network = HvdcTestNetwork.createBase(networkFactory);
        VoltageLevel vl1 = network.getVoltageLevel("VL1");
        VscConverterStation cs1 = ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)vl1.newVscConverterStation().setId("C1")).setName("Converter1")).setConnectableBus("B1")).setBus("B1")).setLossFactor(1.1f)).setVoltageSetpoint(405.0).setVoltageRegulatorOn(true).add();
        cs1.getTerminal().setP(100.0).setQ(50.0);
        cs1.newReactiveCapabilityCurve().beginPoint().setP(5.0).setMinQ(0.0).setMaxQ(10.0).endPoint().beginPoint().setP(10.0).setMinQ(0.0).setMaxQ(10.0).endPoint().add();
        VoltageLevel vl2 = network.getVoltageLevel("VL2");
        VscConverterStation cs2 = ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)vl2.newVscConverterStation().setId("C2")).setName("Converter2")).setNode(2)).setLossFactor(1.1f)).setReactivePowerSetpoint(123.0).setVoltageRegulatorOn(false).setRegulatingTerminal(cs1.getTerminal()).add();
        cs2.newMinMaxReactiveLimits().setMinQ(0.0).setMaxQ(10.0).add();
        HvdcTestNetwork.createLine(network);
        return network;
    }

    public static Network createLcc() {
        return HvdcTestNetwork.createLcc(NetworkFactory.findDefault());
    }

    public static Network createLcc(NetworkFactory networkFactory) {
        Network network = HvdcTestNetwork.createBase(networkFactory);
        VoltageLevel vl1 = network.getVoltageLevel("VL1");
        ShuntCompensator shunt1 = ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)vl1.newShuntCompensator().setId("C1_Filter1")).setName("Filter 1")).setConnectableBus("B1")).setBus("B1")).setSectionCount(1).newLinearModel().setBPerSection(1.0E-5).setMaximumSectionCount(1).add().add();
        shunt1.getTerminal().setQ(25.0);
        ShuntCompensator shunt2 = ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)vl1.newShuntCompensator().setId("C1_Filter2")).setName("Filter 2")).setConnectableBus("B1")).setSectionCount(0).newLinearModel().setBPerSection(2.0E-5).setMaximumSectionCount(1).add().add();
        shunt2.getTerminal().setQ(25.0);
        LccConverterStation cs1 = ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)vl1.newLccConverterStation().setId("C1")).setName("Converter1")).setConnectableBus("B1")).setBus("B1")).setLossFactor(1.1f)).setPowerFactor(0.5f).add();
        cs1.getTerminal().setP(100.0).setQ(50.0);
        VoltageLevel vl2 = network.getVoltageLevel("VL2");
        ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)vl2.getNodeBreakerView().newDisconnector().setId("DISC_BBS1_BK2")).setName(DISCONNECTOR_NAME)).setNode1(0).setNode2(3).setOpen(false).setRetained(false).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)vl2.getNodeBreakerView().newBreaker().setId("BK2")).setName(BREAKER_NAME)).setNode1(3).setNode2(4).setOpen(false).setRetained(true).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)vl2.getNodeBreakerView().newDisconnector().setId("DISC_BBS1_BK3")).setName(DISCONNECTOR_NAME)).setNode1(0).setNode2(5).setOpen(false).setRetained(false).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)vl2.getNodeBreakerView().newBreaker().setId("BK3")).setName(BREAKER_NAME)).setNode1(5).setNode2(6).setOpen(false).setRetained(true).add();
        ShuntCompensator shunt3 = ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)vl2.newShuntCompensator().setId("C2_Filter1")).setName("Filter 3")).setNode(4)).setSectionCount(1).newLinearModel().setBPerSection(3.0E-5).setMaximumSectionCount(1).add().add();
        shunt3.getTerminal().setQ(12.5);
        ShuntCompensator shunt4 = ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)vl2.newShuntCompensator().setId("C2_Filter2")).setName("Filter 4")).setNode(6)).setSectionCount(1).newLinearModel().setBPerSection(4.0E-5).setMaximumSectionCount(1).add().add();
        shunt4.getTerminal().setQ(12.5);
        LccConverterStation cs2 = ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)vl2.newLccConverterStation().setId("C2")).setName("Converter2")).setNode(2)).setLossFactor(1.1f)).setPowerFactor(0.6f).add();
        cs2.getTerminal().setP(75.0).setQ(25.0);
        HvdcTestNetwork.createLine(network);
        return network;
    }
}

