/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import java.util.Objects;

public final class NetworkBusBreakerTest1Factory {
    private NetworkBusBreakerTest1Factory() {
    }

    public static Network create() {
        return NetworkBusBreakerTest1Factory.create(NetworkFactory.findDefault(), null);
    }

    public static Network create(String networkId) {
        return NetworkBusBreakerTest1Factory.create(NetworkFactory.findDefault(), networkId);
    }

    public static Network create(NetworkFactory networkFactory, String nid) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork(NetworkBusBreakerTest1Factory.id("network", nid), "test");
        Substation substation1 = ((SubstationAdder)network.newSubstation().setId(NetworkBusBreakerTest1Factory.id("substation1", nid))).setCountry(Country.FR).setTso(NetworkBusBreakerTest1Factory.id("TSO1", nid)).setGeographicalTags(new String[]{NetworkBusBreakerTest1Factory.id("region1", nid)}).add();
        VoltageLevel voltageLevel1 = ((VoltageLevelAdder)substation1.newVoltageLevel().setId(NetworkBusBreakerTest1Factory.id("voltageLevel1", nid))).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        VoltageLevel.BusBreakerView topology1 = voltageLevel1.getBusBreakerView();
        Bus voltageLevel1Bus1 = ((BusAdder)topology1.newBus().setId(NetworkBusBreakerTest1Factory.id("voltageLevel1Bus1", nid))).add();
        Bus voltageLevel1Bus2 = ((BusAdder)topology1.newBus().setId(NetworkBusBreakerTest1Factory.id("voltageLevel1Bus2", nid))).add();
        ((VoltageLevel.BusBreakerView.SwitchAdder)topology1.newSwitch().setId(NetworkBusBreakerTest1Factory.id("voltageLevel1Breaker1", nid))).setOpen(false).setBus1(voltageLevel1Bus1.getId()).setBus2(voltageLevel1Bus2.getId()).add();
        Load load1 = ((LoadAdder)((LoadAdder)voltageLevel1.newLoad().setId(NetworkBusBreakerTest1Factory.id("load1", nid))).setBus(voltageLevel1Bus1.getId())).setP0(10.0).setQ0(3.0).add();
        load1.setP0(10.0);
        Generator generator1 = ((GeneratorAdder)((GeneratorAdder)voltageLevel1.newGenerator().setId(NetworkBusBreakerTest1Factory.id("generator1", nid))).setEnergySource(EnergySource.NUCLEAR).setMinP(200.0).setMaxP(900.0).setVoltageRegulatorOn(true).setTargetP(900.0).setTargetV(380.0).setBus(voltageLevel1Bus2.getId())).add();
        generator1.newReactiveCapabilityCurve().beginPoint().setP(200.0).setMinQ(300.0).setMaxQ(500.0).endPoint().beginPoint().setP(900.0).setMinQ(300.0).setMaxQ(500.0).endPoint().add();
        return network;
    }

    public static String id(String localId, String networkId) {
        return networkId != null ? "n" + networkId + "_" + localId : localId;
    }
}

