/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import java.util.Objects;

public final class NoEquipmentNetworkFactory {
    private NoEquipmentNetworkFactory() {
    }

    public static Network create() {
        return NoEquipmentNetworkFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork("test", "test");
        Substation substation = ((SubstationAdder)network.newSubstation().setId("sub")).setCountry(Country.FR).setTso("RTE").add();
        VoltageLevel voltageLevelA = ((VoltageLevelAdder)((VoltageLevelAdder)substation.newVoltageLevel().setId("vl1")).setName("vl1")).setNominalV(440.0).setHighVoltageLimit(400.0).setLowVoltageLimit(200.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)((BusAdder)voltageLevelA.getBusBreakerView().newBus().setId("busA")).setName("busA")).add();
        VoltageLevel voltageLevelB = ((VoltageLevelAdder)((VoltageLevelAdder)substation.newVoltageLevel().setId("vl2")).setName("vl2")).setNominalV(200.0).setHighVoltageLimit(400.0).setLowVoltageLimit(200.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)((BusAdder)voltageLevelB.getBusBreakerView().newBus().setId("busB")).setName("busB")).add();
        return network;
    }
}

