/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import java.util.Objects;
import org.joda.time.DateTime;

public final class ReactiveLimitsTestNetworkFactory {
    private ReactiveLimitsTestNetworkFactory() {
    }

    public static Network create() {
        return ReactiveLimitsTestNetworkFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork("ReactiveLimits", "???");
        network.setCaseDate(DateTime.parse((String)"2016-01-01T10:00:00.000+02:00"));
        Substation s = ((SubstationAdder)network.newSubstation().setId("S")).setCountry(Country.FR).setTso("RTE").add();
        VoltageLevel vl = ((VoltageLevelAdder)s.newVoltageLevel().setId("VL")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl.getBusBreakerView().newBus().setId("B")).add();
        Generator g1 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl.newGenerator().setId("G1")).setEnergySource(EnergySource.OTHER).setMaxP(10.0).setMinP(0.0).setVoltageRegulatorOn(true).setTargetV(380.0).setTargetP(10.0).setBus("B")).setConnectableBus("B")).add();
        g1.newReactiveCapabilityCurve().beginPoint().setP(5.0).setMinQ(1.0).setMaxQ(10.0).endPoint().beginPoint().setP(10.0).setMinQ(-10.0).setMaxQ(1.0).endPoint().add();
        Generator g2 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl.newGenerator().setId("G2")).setEnergySource(EnergySource.OTHER).setMaxP(10.0).setMinP(0.0).setVoltageRegulatorOn(true).setTargetV(380.0).setTargetP(10.0).setBus("B")).setConnectableBus("B")).add();
        g2.newMinMaxReactiveLimits().setMinQ(1.0).setMaxQ(10.0).add();
        return network;
    }
}

