/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.triplestore.api;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.util.ServiceLoaderCache;
import com.powsybl.triplestore.api.TripleStore;
import com.powsybl.triplestore.api.TripleStoreFactoryService;
import com.powsybl.triplestore.api.TripleStoreOptions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TripleStoreFactory {
    private static final ServiceLoaderCache<TripleStoreFactoryService> LOADER = new ServiceLoaderCache(TripleStoreFactoryService.class);
    public static final String DEFAULT_IMPLEMENTATION = "rdf4j";

    private TripleStoreFactory() {
    }

    public static TripleStore create() {
        return TripleStoreFactory.create(DEFAULT_IMPLEMENTATION);
    }

    public static TripleStore create(TripleStoreOptions options) {
        return TripleStoreFactory.create(DEFAULT_IMPLEMENTATION, options);
    }

    public static TripleStore copy(TripleStore source) {
        String impl = source.getImplementationName();
        for (TripleStoreFactoryService ts : LOADER.getServices()) {
            if (!ts.getImplementationName().equals(impl)) continue;
            return ts.copy(source);
        }
        throw new PowsyblException("No implementation available for triple store " + impl);
    }

    public static TripleStore create(String impl) {
        Objects.requireNonNull(impl);
        for (TripleStoreFactoryService ts : LOADER.getServices()) {
            if (!ts.getImplementationName().equals(impl)) continue;
            return ts.create();
        }
        throw new PowsyblException("No implementation available for triple store " + impl);
    }

    public static TripleStore create(String impl, TripleStoreOptions options) {
        Objects.requireNonNull(impl);
        for (TripleStoreFactoryService ts : LOADER.getServices()) {
            if (!ts.getImplementationName().equals(impl)) continue;
            return ts.create(options);
        }
        throw new PowsyblException("No implementation available for triple store " + impl);
    }

    public static List<String> allImplementations() {
        return LOADER.getServices().stream().map(TripleStoreFactoryService::getImplementationName).collect(Collectors.toList());
    }

    public static List<String> implementationsWorkingWithNestedGraphClauses() {
        return LOADER.getServices().stream().filter(TripleStoreFactoryService::isWorkingWithNestedGraphClauses).map(TripleStoreFactoryService::getImplementationName).collect(Collectors.toList());
    }

    public static List<String> implementationsBadNestedGraphClauses() {
        return LOADER.getServices().stream().filter(ts -> !ts.isWorkingWithNestedGraphClauses()).map(TripleStoreFactoryService::getImplementationName).collect(Collectors.toList());
    }

    public static List<String> onlyDefaultImplementation() {
        return Collections.singletonList(DEFAULT_IMPLEMENTATION);
    }

    public static String defaultImplementation() {
        return DEFAULT_IMPLEMENTATION;
    }
}

