/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.v2.VirusDetectConf;
import com.qcloud.cos.model.ciModel.job.v2.VirusDetectInput;
import com.qcloud.cos.model.ciModel.job.v2.VirusDetectJobRequest;
import com.qcloud.cos.model.ciModel.job.v2.VirusDetectJobResponse;
import com.qcloud.cos.model.ciModel.job.v2.VirusDetectRequest;
import com.qcloud.cos.model.ciModel.job.v2.VirusDetectResponse;
import com.qcloud.cos.utils.Jackson;

public class VirusDetectDemo {
    public static void main(String[] args) {
        COSClient client = ClientUtils.getTestClient();
        VirusDetectDemo.virusDetectWithCOSObject(client);
    }

    public static void virusDetectWithCOSObject(COSClient client) {
        VirusDetectRequest request = new VirusDetectRequest();
        request.setBucketName("demo-1234567890");
        VirusDetectInput input = request.getInput();
        input.setObject("test/virus-test.doc");
        VirusDetectConf conf = request.getConf();
        conf.setDetectType("Virus");
        conf.setCallback("http://www.callback.com");
        VirusDetectResponse response = client.createVirusDetectJob(request);
        System.out.println("\u75c5\u6bd2\u68c0\u6d4b\u4efb\u52a1\uff08COS\u6587\u4ef6\uff09\u54cd\u5e94: " + Jackson.toJsonString(response));
    }

    public static void describeVirusDetectJob(COSClient client, String jobId) {
        VirusDetectJobRequest request = new VirusDetectJobRequest();
        request.setBucketName("demo-1234567890");
        request.setJobId(jobId);
        VirusDetectJobResponse response = client.describeVirusDetectJob(request);
        System.out.println("\u75c5\u6bd2\u68c0\u6d4b\u4efb\u52a1\u67e5\u8be2\u54cd\u5e94: " + Jackson.toJsonString(response));
        if (response.getJobsDetail() != null) {
            System.out.println("\u4efb\u52a1\u72b6\u6001: " + response.getJobsDetail().getState());
            System.out.println("\u68c0\u6d4b\u5efa\u8bae: " + response.getJobsDetail().getSuggestion());
            if (response.getJobsDetail().getDetectDetail() != null && response.getJobsDetail().getDetectDetail().getResult() != null) {
                System.out.println("\u68c0\u6d4b\u5230\u7684\u75c5\u6bd2\u6570\u91cf: " + response.getJobsDetail().getDetectDetail().getResult().size());
                response.getJobsDetail().getDetectDetail().getResult().forEach(result -> System.out.println("\u6587\u4ef6\u540d: " + result.getFileName() + ", \u75c5\u6bd2\u540d: " + result.getVirusName()));
            }
        }
    }
}

