/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.region;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.UrlComponentUtils;
import java.io.Serializable;

public class Region
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String regionName;
    private String displayName;

    public Region(String region_name) {
        this(region_name, region_name);
    }

    public Region(String region_name, String displayName) {
        this.regionName = region_name;
        this.displayName = displayName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof Region) {
            String anotherRegionName = ((Region)anObject).getRegionName();
            return anotherRegionName.equals(this.regionName);
        }
        return false;
    }

    public static String formatRegion(Region region) throws CosClientException {
        return Region.formatRegion(region.getRegionName());
    }

    public static String formatRegion(String regionName) throws CosClientException {
        UrlComponentUtils.validateRegionName(regionName);
        if (regionName.startsWith("cos.")) {
            return regionName;
        }
        if (regionName.equals("cn-east") || regionName.equals("cn-south") || regionName.equals("cn-north") || regionName.equals("cn-south-2") || regionName.equals("cn-southwest") || regionName.equals("sg")) {
            return regionName;
        }
        return "cos." + regionName;
    }
}

