/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.iam.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;

public class ApiGetActions
extends Api {
    public ApiGetActions(Client client) {
        super(client);
    }

    public ApiGetActions(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        private GetActionsResp data;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
            this.data = Json.decode(response.bodyString(), GetActionsResp.class);
        }

        public GetActionsResp getData() {
            return this.data;
        }

        public static final class GetActionsResp {
            @SerializedName(value="data")
            private GetActionsData data;

            public GetActionsData getData() {
                return this.data;
            }
        }

        public static final class GetActionsData {
            @SerializedName(value="count")
            private Integer count;
            @SerializedName(value="list")
            private GetAction[] list;

            public Integer getCount() {
                return this.count;
            }

            public GetAction[] getList() {
                return this.list;
            }
        }

        public static final class GetAction {
            @SerializedName(value="id")
            private String id;
            @SerializedName(value="name")
            private String name;
            @SerializedName(value="alias")
            private String alias;
            @SerializedName(value="service")
            private String service;
            @SerializedName(value="scope")
            private Integer scope;
            @SerializedName(value="enabled")
            private Boolean enabled;
            @SerializedName(value="created_at")
            private String createdAt;
            @SerializedName(value="updated_at")
            private String updatedAt;

            public String getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public String getAlias() {
                return this.alias;
            }

            public String getService() {
                return this.service;
            }

            public Integer getScope() {
                return this.scope;
            }

            public Boolean getEnabled() {
                return this.enabled;
            }

            public String getCreatedAt() {
                return this.createdAt;
            }

            public String getUpdatedAt() {
                return this.updatedAt;
            }
        }
    }

    public static class Request
    extends Api.Request {
        private String service = null;
        private Integer page = null;
        private Integer pageSize = null;

        public Request(String urlPrefix) {
            super(urlPrefix);
            this.setMethod(MethodType.GET);
            this.setAuthType(1);
        }

        public Request setService(String service) {
            this.service = service;
            return this;
        }

        public Request setPage(Integer page) {
            this.page = page;
            return this;
        }

        public Request setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("iam/v1/actions");
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            if (this.service != null) {
                this.addQueryPair("service", this.service);
            }
            if (this.page != null) {
                this.addQueryPair("page", this.page);
            }
            if (this.pageSize != null) {
                this.addQueryPair("page_size", this.pageSize);
            }
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            super.buildBodyInfo();
        }
    }
}

